/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.xpect.config;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.n4js.xpect.config.Config;
import org.eclipse.n4js.xpect.config.StringList;
import org.eclipse.n4js.xpect.config.VarDef;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.setup.XpectSetupRoot;
import org.eclipse.xpect.xtext.lib.setup.InjectorSetup;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@XpectSetupRoot
@XpectImport({ Config.class, VarDef.class, InjectorSetup.class, StringList.class })
@SuppressWarnings("all")
public class XpEnvironmentData {
  private List<VarDef> vars = CollectionLiterals.<VarDef>newArrayList();
  
  private Config root;
  
  private XtextResource resourceUnderTest = null;
  
  public Config add(final Config cRoot) {
    return this.root = cRoot;
  }
  
  public boolean add(final VarDef aVar) {
    return this.vars.add(aVar);
  }
  
  /**
   * Searches for Variable with name sname recursivly, first toplevel, then in config.
   */
  public VarDef getVar(final String sname) {
    final Function1<VarDef, Boolean> _function = (VarDef it) -> {
      return Boolean.valueOf(Objects.equal(it.name, sname));
    };
    final VarDef topVar = IterableExtensions.<VarDef>findFirst(this.vars, _function);
    if ((topVar != null)) {
      return topVar;
    } else {
      final VarDef ret = this.root.getVar(sname);
      if ((ret != null)) {
        return ret;
      }
      throw new UnknownError((("undefined Variable in setup: \'" + sname) + "\'"));
    }
  }
  
  @Override
  public String toString() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("XpEnvironmentData with config=");
    _builder.append(this.root);
    _builder.append(" vars=");
    _builder.append(this.vars);
    _builder.append(".");
    return _builder.toString();
  }
  
  public XtextResource setResourceUnderTest(final XtextResource resource) {
    return this.resourceUnderTest = resource;
  }
  
  public XtextResource getResourceUnderTest() {
    return this.resourceUnderTest;
  }
}
