/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.postprocessing.ASTMetaInfoUtils;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;

@XpectImport(value={N4JSOffsetAdapter.class})
public class TypeXpectMethod {
    @Inject
    private N4JSTypeSystem ts;

    @ParameterParser(syntax="('of' arg1=OFFSET)?")
    @Xpect
    public void type(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion arg1) {
        String actual = this.getTypeString(arg1, false);
        if (expectation == null) {
            throw new IllegalStateException("No expectation specified, add '--> Type'");
        }
        expectation.assertEquals((Object)actual);
    }

    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    @Xpect
    public void expectedType(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion arg1) {
        String actual = this.getTypeString(arg1, true);
        if (expectation == null) {
            throw new IllegalStateException("No expectation specified, add '--> Type'");
        }
        expectation.assertEquals((Object)actual);
    }

    private String getTypeString(N4JSOffsetAdapter.IEObjectCoveringRegion offset, boolean expectedType) {
        Result result;
        EObject eobject = offset.getEObject();
        if (eobject instanceof LiteralOrComputedPropertyName) {
            eobject = eobject.eContainer();
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)eobject);
        if (expectedType) {
            if (!(eobject instanceof Expression) || eobject.eContainer() == null) {
                return "Not an Expression at given region (required to obtain expected type); got instead: " + eobject.eClass().getName();
            }
            result = this.ts.expectedTypeIn(G, eobject.eContainer(), (Expression)eobject);
        } else {
            if (eobject instanceof BindingProperty && ((BindingProperty)eobject).getValue() != null && ((BindingProperty)eobject).getValue().getVarDecl() != null) {
                eobject = ((BindingProperty)eobject).getValue().getVarDecl();
            }
            if (!(eobject instanceof TypableElement)) {
                return "Not a TypableElement at given region; got instead: " + eobject.eClass().getName();
            }
            result = this.ts.type(G, (TypableElement)eobject);
        }
        String calculatedString = result.getRuleFailedException() != null ? result.getRuleFailedException().getMessage() : ((TypeRef)result.getValue()).getTypeRefAsString();
        return calculatedString;
    }

    @ParameterParser(syntax="'of' arg1=OFFSET")
    @Xpect
    public void typeArgs(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion arg1) {
        String actual = this.getTypeArgumentsString(arg1);
        if (expectation == null) {
            throw new IllegalStateException("no expectation specified, add '--> type arguments string'");
        }
        expectation.assertEquals((Object)actual);
    }

    private String getTypeArgumentsString(N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        List inferredTypeArgs;
        EObject container;
        EObject eobject = offset != null ? offset.getEObject() : null;
        EObject eObject = container = eobject != null ? eobject.eContainer() : null;
        if (eobject == null || !(container instanceof ParameterizedCallExpression) || ((ParameterizedCallExpression)container).getTarget() != eobject) {
            return "xpect method error: offset not given or does not point to target of a call expression";
        }
        if (!(eobject.eResource() instanceof N4JSResource)) {
            return "xpect method error: offset does not point to an EObject contained in a N4JSResource";
        }
        ParameterizedCallExpression callExpr = (ParameterizedCallExpression)container;
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)eobject);
        Result targetTypeRef = this.ts.type(G, (TypableElement)callExpr.getTarget());
        if (targetTypeRef.failed() || !(targetTypeRef.getValue() instanceof FunctionTypeExprOrRef)) {
            return "xpect method error: cannot infer type of call expression target OR it's not a FunctionTypeExprOrRef";
        }
        EList typeParams = ((FunctionTypeExprOrRef)targetTypeRef.getValue()).getTypeVars();
        int expectedNumOfTypeArgs = typeParams.size();
        List<Object> typeArgs = callExpr.getTypeArgs().isEmpty() ? ((inferredTypeArgs = ASTMetaInfoUtils.getInferredTypeArgs((ParameterizedCallExpression)callExpr)) != null ? inferredTypeArgs : Collections.emptyList()) : callExpr.getTypeArgs();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < expectedNumOfTypeArgs) {
            TypeRef inferredTypeArg;
            TypeRef typeRef = inferredTypeArg = i < typeArgs.size() ? (TypeRef)typeArgs.get(i) : null;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (inferredTypeArg != null) {
                sb.append(inferredTypeArg.getTypeRefAsString());
            } else {
                sb.append("*missing*");
            }
            ++i;
        }
        return sb.toString();
    }
}

