/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.function.BooleanSupplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.CustomInternalTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.xsemantics.InternalTypeSystem;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

abstract class AbstractProcessor {
    private static final boolean DEBUG_LOG = false;
    private static final boolean DEBUG_LOG_RESULT = false;
    private static final boolean DEBUG_RIGID = false;
    @Inject
    private InternalTypeSystem ts_internal;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    AbstractProcessor() {
    }

    protected void checkCanceled(RuleEnvironment G) {
        this.operationCanceledManager.checkCanceled(RuleEnvironmentExtensions.getCancelIndicator(G));
    }

    protected Result<TypeRef> askXsemanticsForType(RuleEnvironment G, RuleApplicationTrace trace, TypableElement elem) {
        TStructMember definedMember;
        boolean _eIsProxy = elem.eIsProxy();
        if (_eIsProxy) {
            UnknownTypeRef _createUnknownTypeRef = TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
            return new Result((Object)_createUnknownTypeRef);
        }
        TStructMember _xifexpression = null;
        if (elem instanceof TStructMember) {
            _xifexpression = ((TStructMember)elem).getDefinedMember();
        }
        if ((definedMember = _xifexpression) != null && N4JSLanguageUtils.isASTNode((EObject)elem)) {
            return this.askXsemanticsForType(G, trace, (TypableElement)definedMember);
        }
        return ((CustomInternalTypeSystem)this.ts_internal).use_type_judgment_from_PostProcessors(G, trace, elem);
    }

    protected void handleAsyncFunctionDefinition(RuleEnvironment G, FunctionDefinition funDef, ASTMetaInfoCache cache) {
        TypeRef innerReturnTypeRef;
        Type tFunction;
        boolean _isAsync = funDef.isAsync();
        if (_isAsync && (tFunction = funDef.getDefinedType()) instanceof TFunction && (innerReturnTypeRef = ((TFunction)tFunction).getReturnTypeRef()) != null && !(innerReturnTypeRef instanceof DeferredTypeRef)) {
            boolean _not;
            BuiltInTypeScope scope = RuleEnvironmentExtensions.getBuiltInTypeScope(G);
            boolean _isPromise = TypeUtils.isPromise((TypeRef)innerReturnTypeRef, (BuiltInTypeScope)scope);
            boolean bl = _not = !_isPromise;
            if (_not) {
                ParameterizedTypeRef outerReturnTypeRef = TypeUtils.createPromiseTypeRef((BuiltInTypeScope)scope, (TypeArgument)innerReturnTypeRef, null);
                Procedures.Procedure0 _function = () -> ((TFunction)tFunction).setReturnTypeRef((TypeRef)outerReturnTypeRef);
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{tFunction});
            }
        }
    }

    protected void handleGeneratorFunctionDefinition(RuleEnvironment G, FunctionDefinition funDef, ASTMetaInfoCache cache) {
        TypeRef innerReturnTypeRef;
        Type tFunction;
        boolean _isGenerator = funDef.isGenerator();
        if (_isGenerator && (tFunction = funDef.getDefinedType()) instanceof TFunction && (innerReturnTypeRef = ((TFunction)tFunction).getReturnTypeRef()) != null && !(innerReturnTypeRef instanceof DeferredTypeRef)) {
            boolean _not;
            BuiltInTypeScope scope = RuleEnvironmentExtensions.getBuiltInTypeScope(G);
            boolean _isGenerator_1 = TypeUtils.isGenerator((TypeRef)innerReturnTypeRef, (BuiltInTypeScope)scope);
            boolean bl = _not = !_isGenerator_1;
            if (_not) {
                ParameterizedTypeRef outerReturnTypeRef = TypeUtils.createGeneratorTypeRef((BuiltInTypeScope)scope, (FunctionDefinition)funDef);
                Procedures.Procedure0 _function = () -> ((TFunction)tFunction).setReturnTypeRef((TypeRef)outerReturnTypeRef);
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{tFunction});
            }
        }
    }

    protected static String getObjectInfo(EObject obj) {
        String _xifexpression = null;
        if (obj == null) {
            _xifexpression = "<null>";
        } else {
            String _xifexpression_1 = null;
            if (obj instanceof IdentifierRef) {
                String _tokenText = NodeModelUtils.getTokenText((INode)NodeModelUtils.findActualNodeFor((EObject)obj));
                String _plus = "IdentifierRef \"" + _tokenText;
                _xifexpression_1 = String.valueOf(_plus) + "\"";
            } else {
                String _xblockexpression = null;
                String name = AbstractProcessor.getName(obj);
                String _xifexpression_2 = null;
                if (name != null) {
                    String _name = obj.eClass().getName();
                    String _plus_1 = String.valueOf(_name) + " \"";
                    String _plus_2 = String.valueOf(_plus_1) + name;
                    _xifexpression_2 = String.valueOf(_plus_2) + "\"";
                } else {
                    _xifexpression_2 = obj.eClass().getName();
                }
                _xifexpression_1 = _xblockexpression = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected static String getName(EObject obj) {
        String _switchResult = null;
        boolean _matched = false;
        if (obj instanceof NamedElement) {
            _matched = true;
            _switchResult = ((NamedElement)obj).getName();
        }
        if (!_matched && obj instanceof IdentifiableElement) {
            _matched = true;
            _switchResult = ((IdentifiableElement)obj).getName();
        }
        return _switchResult;
    }

    protected static void log(int indentLevel, Result<TypeRef> result) {
        boolean _not;
        boolean _isDEBUG_LOG = AbstractProcessor.isDEBUG_LOG();
        boolean bl = _not = !_isDEBUG_LOG;
        if (_not) {
            return;
        }
        AbstractProcessor.log(indentLevel, AbstractProcessor.resultToString(result));
    }

    protected static void log(int indentLevel, EObject astNode, ASTMetaInfoCache cache) {
        boolean _not;
        boolean _isDEBUG_LOG = AbstractProcessor.isDEBUG_LOG();
        boolean bl = _not = !_isDEBUG_LOG;
        if (_not) {
            return;
        }
        boolean _isTypableNode = N4JSLanguageUtils.isTypableNode(astNode);
        if (_isTypableNode) {
            Result<TypeRef> result = cache.getTypeFailSafe((TypableElement)astNode);
            String _xifexpression = null;
            _xifexpression = result != null ? AbstractProcessor.resultToString(result) : "*** MISSING ***";
            String resultStr = _xifexpression;
            String _objectInfo = AbstractProcessor.getObjectInfo(astNode);
            String _plus = String.valueOf(_objectInfo) + " ";
            String _plus_1 = String.valueOf(_plus) + resultStr;
            AbstractProcessor.log(indentLevel, _plus_1);
        } else {
            AbstractProcessor.log(indentLevel, AbstractProcessor.getObjectInfo(astNode));
        }
        EList _eContents = astNode.eContents();
        for (EObject childNode : _eContents) {
            AbstractProcessor.log(indentLevel + 1, childNode, cache);
        }
    }

    protected static void log(int indentLevel, String msg) {
        boolean _not;
        boolean _isDEBUG_LOG = AbstractProcessor.isDEBUG_LOG();
        boolean bl = _not = !_isDEBUG_LOG;
        if (_not) {
            return;
        }
        String _indent = AbstractProcessor.indent(indentLevel);
        String _plus = String.valueOf(_indent) + msg;
        InputOutput.println((Object)_plus);
    }

    protected static void logErr(String msg) {
        System.out.flush();
        System.err.println(msg);
        System.err.flush();
    }

    protected static Throwable logException(Throwable th) {
        th.printStackTrace();
        return th;
    }

    protected static void assertTrueIfRigid(ASTMetaInfoCache cache, String message, BooleanSupplier check) {
        boolean _isDEBUG_RIGID = AbstractProcessor.isDEBUG_RIGID();
        if (_isDEBUG_RIGID) {
            AbstractProcessor.assertTrueIfRigid(cache, message, check.getAsBoolean());
        }
    }

    protected static void assertTrueIfRigid(ASTMetaInfoCache cache, String message, boolean actual) {
        if (AbstractProcessor.isDEBUG_RIGID() && !actual) {
            boolean _not;
            Error e = new Error(message);
            boolean _hasBrokenAST = cache.hasBrokenAST();
            boolean bl = _not = !_hasBrokenAST;
            if (_not) {
                UtilN4.reportError((Throwable)e);
            }
            Throwables.propagate((Throwable)e);
        }
    }

    protected static boolean isDEBUG_LOG() {
        return false;
    }

    protected static boolean isDEBUG_LOG_RESULT() {
        return false;
    }

    protected static boolean isDEBUG_RIGID() {
        return false;
    }

    protected static String resultToString(Result<TypeRef> result) {
        String _xifexpression = null;
        if (result != null && result.failed()) {
            String _message = result.getRuleFailedException().getMessage();
            _xifexpression = "!FAILED! " + _message;
        } else {
            TypeRef _value = null;
            if (result != null) {
                _value = (TypeRef)result.getValue();
            }
            String _typeRefAsString = null;
            if (_value != null) {
                _typeRefAsString = _value.getTypeRefAsString();
            }
            _xifexpression = _typeRefAsString;
        }
        return "RESULT: " + _xifexpression;
    }

    protected static String indent(int indentLevel) {
        Functions.Function1 _function = it -> "    ";
        return IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)new ExclusiveRange(0, indentLevel, true), (Functions.Function1)_function));
    }
}

