/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.AbstractPolyProcessor;
import org.eclipse.n4js.postprocessing.PolyProcessor_ArrayLiteral;
import org.eclipse.n4js.postprocessing.PolyProcessor_CallExpression;
import org.eclipse.n4js.postprocessing.PolyProcessor_FunctionExpression;
import org.eclipse.n4js.postprocessing.PolyProcessor_ObjectLiteral;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.typesystem.constraints.TypeConstraint;
import org.eclipse.n4js.utils.DestructureHelper;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
class PolyProcessor
extends AbstractPolyProcessor {
    @Inject
    private PolyProcessor_ArrayLiteral arrayLiteralProcessor;
    @Inject
    private PolyProcessor_ObjectLiteral objectLiteralProcessor;
    @Inject
    private PolyProcessor_FunctionExpression functionExpressionProcessor;
    @Inject
    private PolyProcessor_CallExpression callExpressionProcessor;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private DestructureHelper destructureHelper;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    PolyProcessor() {
    }

    boolean isResponsibleFor(TypableElement astNode) {
        return this.isPoly((EObject)astNode) || astNode instanceof Argument && astNode.eContainer() instanceof ParameterizedCallExpression && this.isPoly(astNode.eContainer()) || astNode instanceof FormalParameter && astNode.eContainer() instanceof FunctionExpression && this.isPoly(astNode.eContainer()) || astNode instanceof FormalParameter && astNode.eContainer() instanceof PropertyMethodDeclaration && this.isPoly(astNode.eContainer()) || astNode instanceof ArrayElement && astNode.eContainer() instanceof ArrayLiteral && this.isPoly(astNode.eContainer()) || astNode instanceof PropertyAssignment && astNode.eContainer() instanceof ObjectLiteral && this.isPoly(astNode.eContainer());
    }

    boolean isEntryPoint(TypableElement astNode) {
        return this.isRootPoly((EObject)astNode);
    }

    void inferType(RuleEnvironment G, Expression rootPoly, ASTMetaInfoCache cache) {
        boolean _not_1;
        CancelIndicator _cancelIndicator = RuleEnvironmentExtensions.getCancelIndicator(G);
        InferenceContext infCtx = new InferenceContext(this.ts, this.tsh, this.operationCanceledManager, _cancelIndicator, G, new InferenceVariable[0]);
        boolean _doomTypeInference = this.jsVariantHelper.doomTypeInference((EObject)rootPoly);
        if (_doomTypeInference) {
            infCtx.addConstraint(TypeConstraint.FALSE);
        }
        TypeRef expectedTypeOfPoly = this.destructureHelper.calculateExpectedType(rootPoly, G, infCtx);
        TypeRef _xifexpression = null;
        if (expectedTypeOfPoly != null) {
            _xifexpression = expectedTypeOfPoly;
        } else {
            boolean _not;
            TypeRef _xifexpression_1 = null;
            boolean _isProblematicCaseOfExpectedType = this.isProblematicCaseOfExpectedType((EObject)rootPoly);
            boolean bl = _not = !_isProblematicCaseOfExpectedType;
            if (_not) {
                _xifexpression_1 = (TypeRef)this.ts.expectedTypeIn(G, rootPoly.eContainer(), rootPoly).getValue();
            }
            _xifexpression = _xifexpression_1;
        }
        TypeRef expectedTypeRef = _xifexpression;
        TypeRef typeRef = this.processExpr(G, rootPoly, expectedTypeRef, infCtx, cache);
        boolean _isVoid = TypeUtils.isVoid((TypeArgument)typeRef);
        boolean bl = _not_1 = !_isVoid;
        if (_not_1 && expectedTypeRef != null) {
            infCtx.addConstraint((TypeArgument)typeRef, (TypeArgument)expectedTypeRef, Variance.CO);
        }
        infCtx.solve();
    }

    protected TypeRef processExpr(RuleEnvironment G, Expression expr, TypeRef expectedTypeRef, InferenceContext infCtx, ASTMetaInfoCache cache) {
        boolean _isPoly = this.isPoly(expr);
        if (_isPoly) {
            TypeRef _switchResult = null;
            boolean _matched = false;
            if (expr instanceof ArrayLiteral) {
                _matched = true;
                _switchResult = this.arrayLiteralProcessor.processArrayLiteral(G, (ArrayLiteral)expr, expectedTypeRef, infCtx, cache);
            }
            if (!_matched && expr instanceof ObjectLiteral) {
                _matched = true;
                _switchResult = this.objectLiteralProcessor.processObjectLiteral(G, (ObjectLiteral)expr, expectedTypeRef, infCtx, cache);
            }
            if (!_matched && expr instanceof FunctionExpression) {
                _matched = true;
                _switchResult = this.functionExpressionProcessor.processFunctionExpression(G, (FunctionExpression)expr, expectedTypeRef, infCtx, cache);
            }
            if (!_matched && expr instanceof ParameterizedCallExpression) {
                _matched = true;
                _switchResult = this.callExpressionProcessor.processCallExpression(G, (ParameterizedCallExpression)expr, expectedTypeRef, infCtx, cache);
            }
            if (!_matched) {
                throw new IllegalArgumentException("missing case in #processExpr() for poly expression: " + expr);
            }
            return _switchResult;
        }
        TypeRef result = (TypeRef)this.ts.type(G, (TypableElement)expr).getValue();
        return result;
    }

    private boolean isProblematicCaseOfExpectedType(EObject node) {
        EObject _eContainer = null;
        if (node != null) {
            _eContainer = node.eContainer();
        }
        return _eContainer instanceof RelationalExpression;
    }
}

