/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.ASTProcessor;
import org.eclipse.n4js.postprocessing.AbstractPolyProcessor;
import org.eclipse.n4js.postprocessing.AbstractProcessor;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
class PolyProcessor_FunctionExpression
extends AbstractPolyProcessor {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private ASTProcessor astProcessor;

    PolyProcessor_FunctionExpression() {
    }

    TypeRef processFunctionExpression(RuleEnvironment G, FunctionExpression funExpr, TypeRef expectedTypeRef, InferenceContext infCtx, ASTMetaInfoCache cache) {
        boolean _isEmpty;
        boolean _not_1;
        boolean _tripleNotEquals;
        boolean _not;
        Type _definedType = funExpr.getDefinedType();
        TFunction fun = (TFunction)_definedType;
        boolean _isPoly = this.isPoly((Expression)funExpr);
        boolean bl = _not = !_isPoly;
        if (_not) {
            FunctionTypeExpression funTE = TypeUtils.createFunctionTypeExpression(null, Collections.unmodifiableList(CollectionLiterals.newArrayList()), (List)fun.getFpars(), (TypeRef)fun.getReturnTypeRef());
            return funTE;
        }
        FunctionTypeExpression funTE_1 = TypeRefsFactory.eINSTANCE.createFunctionTypeExpression();
        TypeRef _declaredThisType = fun.getDeclaredThisType();
        boolean bl2 = _tripleNotEquals = _declaredThisType != null;
        if (_tripleNotEquals) {
            funTE_1.setDeclaredThisType((TypeRef)TypeUtils.copy((EObject)fun.getDeclaredThisType()));
        }
        boolean bl3 = _not_1 = !(_isEmpty = fun.getTypeVars().isEmpty());
        if (_not_1) {
            EList _ownedTypeVars = funTE_1.getOwnedTypeVars();
            Functions.Function1 _function = tv -> (TypeVariable)TypeUtils.copy((EObject)tv);
            List _map = ListExtensions.map((List)fun.getTypeVars(), (Functions.Function1)_function);
            Iterables.addAll((Collection)_ownedTypeVars, (Iterable)_map);
        }
        this.processFormalParameters(G, cache, infCtx, funExpr, funTE_1, expectedTypeRef);
        this.processReturnType(G, cache, infCtx, funExpr, funTE_1);
        funTE_1.setReturnValueMarkedOptional(expectedTypeRef instanceof FunctionTypeExprOrRef && ((FunctionTypeExprOrRef)expectedTypeRef).isReturnValueOptional());
        FunctionTypeExpression _xifexpression = null;
        boolean _isEmpty_1 = fun.getTypeVars().isEmpty();
        if (_isEmpty_1) {
            _xifexpression = funTE_1;
        } else {
            FunctionTypeExpression _xblockexpression = null;
            RuleEnvironment Gx = RuleEnvironmentExtensions.newRuleEnvironment(G);
            Functions.Function1 _function_1 = it -> TypeUtils.createTypeRef((Type)it, (TypeArgument[])new TypeArgument[0]);
            RuleEnvironmentExtensions.addTypeMappings(Gx, (List<? extends TypeVariable>)fun.getTypeVars(), ListExtensions.map((List)funTE_1.getOwnedTypeVars(), (Functions.Function1)_function_1));
            TypeArgument _value = (TypeArgument)this.ts.substTypeVariables(Gx, (TypeArgument)funTE_1).getValue();
            _xifexpression = _xblockexpression = (FunctionTypeExpression)_value;
        }
        FunctionTypeExpression resultTypeRef = _xifexpression;
        Consumer<Optional<Map<InferenceVariable, TypeRef>>> _function_1 = solution -> this.handleOnSolved(G, cache, infCtx, funExpr, resultTypeRef, (Optional<Map<InferenceVariable, TypeRef>>)solution);
        infCtx.onSolved(_function_1);
        return resultTypeRef;
    }

    private void processFormalParameters(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, FunctionExpression funExpr, FunctionTypeExpression funTE, TypeRef expectedTypeRef) {
        InferenceVariable iv;
        boolean _tripleEquals;
        TypeRef _declaredTypeRef;
        Type _definedType = funExpr.getDefinedType();
        TFunction fun = (TFunction)_definedType;
        FunctionTypeExprOrRef _xifexpression = null;
        if (expectedTypeRef instanceof FunctionTypeExprOrRef) {
            _xifexpression = (FunctionTypeExprOrRef)expectedTypeRef;
        }
        FunctionTypeExprOrRef expectedFunctionTypeExprOrRef = _xifexpression;
        int len = Math.min(funExpr.getFpars().size(), fun.getFpars().size());
        HashMap<FormalParameter, TFormalParameter> typeRefMap = new HashMap<FormalParameter, TFormalParameter>();
        int i = 0;
        while (i < len) {
            FormalParameter fparAST = (FormalParameter)funExpr.getFpars().get(i);
            TFormalParameter fparT = (TFormalParameter)fun.getFpars().get(i);
            TFormalParameter fparTCopy = (TFormalParameter)TypeUtils.copy((EObject)fparT);
            EList _fpars = funTE.getFpars();
            _fpars.add((Object)fparTCopy);
            typeRefMap.put(fparAST, fparTCopy);
            _declaredTypeRef = fparAST.getDeclaredTypeRef();
            boolean bl = _tripleEquals = _declaredTypeRef == null;
            if (_tripleEquals) {
                TypeRef _typeRef = null;
                if (fparTCopy != null) {
                    _typeRef = fparTCopy.getTypeRef();
                }
                AbstractProcessor.assertTrueIfRigid(cache, "type of formal parameter in TModule should be a DeferredTypeRef", _typeRef instanceof DeferredTypeRef);
                iv = infCtx.newInferenceVariable();
                fparTCopy.setTypeRef((TypeRef)TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]));
            }
            ++i;
        }
        Set _entrySet = typeRefMap.entrySet();
        for (Map.Entry fparPair : _entrySet) {
            FormalParameter fparAST = (FormalParameter)fparPair.getKey();
            TFormalParameter fparTCopy = (TFormalParameter)fparPair.getValue();
            _declaredTypeRef = fparAST.getDeclaredTypeRef();
            boolean bl = _tripleEquals = _declaredTypeRef == null;
            if (!_tripleEquals) continue;
            Type _declaredType = fparTCopy.getTypeRef().getDeclaredType();
            iv = (InferenceVariable)_declaredType;
            this.addConstraintForDefaultInitializers(funExpr, fparAST, fparTCopy, G, cache, iv, infCtx, typeRefMap);
            this.inferOptionalityFromExpectedFpar(funExpr, funTE, expectedFunctionTypeExprOrRef, fparAST, fparTCopy);
        }
    }

    private void addConstraintForDefaultInitializers(FunctionExpression funExpr, FormalParameter fparAST, TFormalParameter fparT, RuleEnvironment G, ASTMetaInfoCache cache, InferenceVariable iv, InferenceContext infCtx, Map<FormalParameter, TFormalParameter> typeRefMap) {
        boolean _isHasInitializerAssignment = fparAST.isHasInitializerAssignment();
        if (_isHasInitializerAssignment) {
            EObject _eContainer = fparAST.eContainer();
            EList allFPars = ((FunctionDefinition)_eContainer).getFpars();
            Expression fparInitializer = fparAST.getInitializer();
            boolean refIsInitializer = false;
            boolean isPostponed = cache.postponedSubTrees.contains(fparInitializer);
            if (fparInitializer instanceof IdentifierRef) {
                IdentifiableElement id = ((IdentifierRef)fparInitializer).getId();
                refIsInitializer = allFPars.contains((Object)id);
            }
            if (refIsInitializer) {
                IdentifierRef iRef = (IdentifierRef)fparInitializer;
                IdentifiableElement _id = iRef.getId();
                FormalParameter fparam = (FormalParameter)_id;
                TFormalParameter fparTCopy = typeRefMap.get(fparam);
                TypeRef tRef = fparTCopy.getTypeRef();
                infCtx.addConstraint((TypeArgument)TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]), (TypeArgument)TypeUtils.copy((EObject)tRef), Variance.CONTRA);
            } else if (!isPostponed) {
                ParameterizedTypeRef _xifexpression = null;
                EObject _eContainer_1 = fparT.eContainer();
                if (_eContainer_1 instanceof ContainerType) {
                    EObject _eContainer_2 = fparT.eContainer();
                    _xifexpression = TypeUtils.createTypeRef((Type)((ContainerType)_eContainer_2), (TypeArgument[])new TypeArgument[0]);
                } else {
                    _xifexpression = null;
                }
                ParameterizedTypeRef context = _xifexpression;
                RuleEnvironment G_withContext = this.ts.createRuleEnvironmentForContext((TypeRef)context, RuleEnvironmentExtensions.getContextResource(G));
                Object _xifexpression_1 = null;
                _xifexpression_1 = fparInitializer != null ? (TypeRef)this.ts.type(G_withContext, (TypableElement)fparInitializer).getValue() : RuleEnvironmentExtensions.undefinedTypeRef(G);
                ParameterizedTypeRef iniTypeRef = _xifexpression_1;
                TypeArgument iniTypeRefSubst = (TypeArgument)this.ts.substTypeVariables(G_withContext, (TypeArgument)iniTypeRef).getValue();
                infCtx.addConstraint((TypeArgument)TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]), (TypeArgument)TypeUtils.copy((EObject)iniTypeRefSubst), Variance.CONTRA);
            }
        }
    }

    private void inferOptionalityFromExpectedFpar(FunctionExpression funExpr, FunctionTypeExpression funTE, FunctionTypeExprOrRef expectedFunctionTypeExprOrRef, FormalParameter fparAST, TFormalParameter fparTCopy) {
        int fparIdx;
        TFormalParameter fparExpected;
        if (expectedFunctionTypeExprOrRef != null && (fparExpected = expectedFunctionTypeExprOrRef.getFparForArgIdx(fparIdx = funExpr.getFpars().indexOf((Object)fparAST))) != null && fparExpected.isOptional() && !fparExpected.isVariadic()) {
            TFormalParameter _last = (TFormalParameter)IterableExtensions.last((Iterable)funTE.getFpars());
            _last.setHasInitializerAssignment(true);
            Procedures.Procedure0 _function = () -> {
                fparAST.setHasInitializerAssignment(true);
                fparTCopy.setHasInitializerAssignment(true);
            };
            EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{fparAST, fparTCopy});
        }
    }

    private void processReturnType(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, FunctionExpression funExpr, FunctionTypeExpression funTE) {
        boolean _tripleNotEquals;
        Type _definedType = funExpr.getDefinedType();
        TFunction fun = (TFunction)_definedType;
        TypeRef returnTypeRef = null;
        TypeRef _returnTypeRef = funExpr.getReturnTypeRef();
        boolean bl = _tripleNotEquals = _returnTypeRef != null;
        if (_tripleNotEquals) {
            returnTypeRef = (TypeRef)TypeUtils.copy((EObject)fun.getReturnTypeRef());
        } else {
            TypeRef _returnTypeRef_1 = fun.getReturnTypeRef();
            AbstractProcessor.assertTrueIfRigid(cache, "return type of TFunction in TModule should be a DeferredTypeRef", _returnTypeRef_1 instanceof DeferredTypeRef);
            boolean _isReturningValue = this.isReturningValue((FunctionDefinition)funExpr);
            if (_isReturningValue) {
                InferenceVariable iv = infCtx.newInferenceVariable();
                returnTypeRef = TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]);
            } else {
                returnTypeRef = RuleEnvironmentExtensions.voidTypeRef(G);
            }
            returnTypeRef = N4JSLanguageUtils.makePromiseIfAsync((FunctionDefinition)funExpr, returnTypeRef, RuleEnvironmentExtensions.getBuiltInTypeScope(G));
            returnTypeRef = N4JSLanguageUtils.makeGeneratorIfGeneratorFunction((FunctionDefinition)funExpr, returnTypeRef, RuleEnvironmentExtensions.getBuiltInTypeScope(G));
        }
        funTE.setReturnTypeRef(returnTypeRef);
    }

    private void handleOnSolved(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, FunctionExpression funExpr, FunctionTypeExpression resultTypeRef, Optional<Map<InferenceVariable, TypeRef>> solution) {
        boolean _tripleNotEquals;
        Map<InferenceVariable, TypeRef> _xifexpression = null;
        boolean _isPresent = solution.isPresent();
        _xifexpression = _isPresent ? (Map<InferenceVariable, TypeRef>)solution.get() : this.createPseudoSolution(infCtx, (TypeRef)RuleEnvironmentExtensions.anyTypeRef(G));
        Map<InferenceVariable, TypeRef> solution2 = _xifexpression;
        TypeRef _applySolution = this.applySolution((TypeRef)resultTypeRef, G, solution2);
        FunctionTypeExprOrRef resultSolved = (FunctionTypeExprOrRef)_applySolution;
        cache.storeType((TypableElement)funExpr, (TypeRef)resultSolved);
        Type _definedType = funExpr.getDefinedType();
        TFunction fun = (TFunction)_definedType;
        this.replaceDeferredTypeRefs(fun, resultSolved);
        boolean _isReturnValueMarkedOptional = fun.isReturnValueMarkedOptional();
        boolean _isReturnValueOptional = resultSolved.isReturnValueOptional();
        boolean bl = _tripleNotEquals = Boolean.valueOf(_isReturnValueMarkedOptional) != Boolean.valueOf(_isReturnValueOptional);
        if (_tripleNotEquals) {
            Procedures.Procedure0 _function = () -> fun.setReturnValueMarkedOptional(resultSolved.isReturnValueOptional());
            EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{fun});
        }
        int len = Math.min(funExpr.getFpars().size(), fun.getFpars().size());
        int i = 0;
        while (i < len) {
            FormalParameter fparAST = (FormalParameter)funExpr.getFpars().get(i);
            TFormalParameter fparT = (TFormalParameter)fun.getFpars().get(i);
            TypeRef fparTw = TypeUtils.wrapIfVariadic((BuiltInTypeScope)RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope, (TypeRef)fparT.getTypeRef(), (FormalParameter)fparAST);
            cache.storeType((TypableElement)fparAST, fparTw);
            ++i;
        }
        if (funExpr instanceof ArrowFunction) {
            AbstractProcessor.log(0, "===START of special handling of single-expression arrow function");
            this.tweakReturnTypeOfSingleExpressionArrowFunction(G, cache, (ArrowFunction)funExpr, resultSolved);
            AbstractProcessor.log(0, "===END of special handling of single-expression arrow function");
        }
    }

    private void tweakReturnTypeOfSingleExpressionArrowFunction(RuleEnvironment G, ASTMetaInfoCache cache, ArrowFunction arrFun, FunctionTypeExprOrRef arrFunTypeRef) {
        boolean _not_1;
        boolean _not;
        boolean _isSingleExprImplicitReturn = arrFun.isSingleExprImplicitReturn();
        boolean bl = _not = !_isSingleExprImplicitReturn;
        if (_not) {
            return;
        }
        Block block = arrFun.getBody();
        if (block == null) {
            return;
        }
        boolean _remove = cache.postponedSubTrees.remove(block);
        boolean bl2 = _not_1 = !_remove;
        if (_not_1) {
            URI _uRI = arrFun.eResource().getURI();
            String _plus = "body of single-expression arrow function not among postponed subtrees, in resource: " + _uRI;
            throw new IllegalStateException(_plus);
        }
        this.astProcessor.processSubtree(G, (EObject)block, cache, 1);
        boolean didTweakReturnType = false;
        Expression expr = arrFun.getSingleExpression();
        if (expr == null) {
            return;
        }
        TypeRef exprTypeRef = (TypeRef)cache.getType((TypableElement)expr).getValue();
        boolean _isVoid = TypeUtils.isVoid((TypeArgument)exprTypeRef);
        if (_isVoid && arrFunTypeRef instanceof FunctionTypeExpression) {
            boolean _not_2;
            boolean _isVoid_1 = TypeUtils.isVoid((TypeArgument)((FunctionTypeExpression)arrFunTypeRef).getReturnTypeRef());
            boolean bl3 = _not_2 = !_isVoid_1;
            if (_not_2) {
                FunctionTypeExprOrRef outerTypeExpectation = this.expectedTypeForArrowFunction(G, arrFun);
                TypeRef _returnTypeRef = null;
                if (outerTypeExpectation != null) {
                    _returnTypeRef = outerTypeExpectation.getReturnTypeRef();
                }
                TypeRef outerReturnTypeExpectation = _returnTypeRef;
                if (outerTypeExpectation == null || outerReturnTypeExpectation != null && TypeUtils.isVoid((TypeArgument)outerReturnTypeExpectation)) {
                    boolean _isDEBUG_LOG = AbstractProcessor.isDEBUG_LOG();
                    if (_isDEBUG_LOG) {
                        TypeRef _returnTypeRef_1 = ((FunctionTypeExpression)arrFunTypeRef).getReturnTypeRef();
                        String _typeRefAsString = null;
                        if (_returnTypeRef_1 != null) {
                            _typeRefAsString = _returnTypeRef_1.getTypeRefAsString();
                        }
                        String _plus_1 = "tweaking return type from " + _typeRefAsString;
                        String _plus_2 = String.valueOf(_plus_1) + " to void";
                        AbstractProcessor.log(1, _plus_2);
                    }
                    Procedures.Procedure0 _function = () -> ((FunctionTypeExpression)arrFunTypeRef).setReturnTypeRef((TypeRef)RuleEnvironmentExtensions.voidTypeRef(G));
                    EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{arrFunTypeRef});
                    boolean _isDEBUG_LOG_1 = AbstractProcessor.isDEBUG_LOG();
                    if (_isDEBUG_LOG_1) {
                        String _typeRefAsString_1 = ((FunctionTypeExpression)arrFunTypeRef).getTypeRefAsString();
                        String _plus_3 = "tweaked type of arrow function is: " + _typeRefAsString_1;
                        AbstractProcessor.log(1, _plus_3);
                    }
                    didTweakReturnType = true;
                }
            }
        }
        if (!didTweakReturnType) {
            AbstractProcessor.log(1, "tweaking of return type not required");
        }
    }

    private void replaceDeferredTypeRefs(TFunction fun, FunctionTypeExprOrRef result) {
        int len = ((Object[])Conversions.unwrapArray((Object)fun.getFpars(), Object.class)).length;
        int i = 0;
        while (i < len) {
            TFormalParameter funFpar = (TFormalParameter)fun.getFpars().get(i);
            TypeRef _typeRef = funFpar.getTypeRef();
            if (_typeRef instanceof DeferredTypeRef) {
                int idx = i;
                Procedures.Procedure0 _function = () -> funFpar.setTypeRef((TypeRef)TypeUtils.copy((EObject)((TFormalParameter)result.getFpars().get(idx)).getTypeRef()));
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{funFpar});
            }
            ++i;
        }
        TypeRef _returnTypeRef = fun.getReturnTypeRef();
        if (_returnTypeRef instanceof DeferredTypeRef) {
            Procedures.Procedure0 _function = () -> fun.setReturnTypeRef((TypeRef)TypeUtils.copy((EObject)result.getReturnTypeRef()));
            EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{fun});
        }
    }

    private FunctionTypeExprOrRef expectedTypeForArrowFunction(RuleEnvironment G, ArrowFunction fe) {
        RuleEnvironment G_new = RuleEnvironmentExtensions.newRuleEnvironment(G);
        TypeRef tr = (TypeRef)this.ts.expectedTypeIn(G_new, fe.eContainer(), (Expression)fe).getValue();
        if (tr instanceof FunctionTypeExprOrRef) {
            return (FunctionTypeExprOrRef)tr;
        }
        return null;
    }
}

