/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.MemberAccess;
import org.eclipse.n4js.n4JS.extensions.ExpressionExtensions;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.members.ComposedMemberFactory;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.ComposedMemberInfoBuilder;
import org.eclipse.n4js.scoping.members.MemberScopeRequest;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.ComposedMemberCache;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeCompareUtils;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public abstract class ComposedMemberScope
extends AbstractScope {
    final ComposedTypeRef composedTypeRef;
    final IScope[] subScopes;
    final MemberScopeRequest request;
    final N4JSTypeSystem ts;
    final boolean writeAccess;

    protected abstract IEObjectDescription getCheckedDescription(String var1, TMember var2);

    protected abstract ComposedMemberFactory getComposedMemberFactory(ComposedMemberInfo var1);

    protected abstract IEObjectDescription createComposedMemberDescriptionWithErrors(IEObjectDescription var1);

    public ComposedMemberScope(ComposedTypeRef composedTypeRef, MemberScopeRequest request, List<IScope> subScopes, N4JSTypeSystem ts) {
        super(IScope.NULLSCOPE, false);
        this.composedTypeRef = composedTypeRef;
        this.subScopes = subScopes.toArray(new IScope[subScopes.size()]);
        this.ts = ts;
        this.request = request;
        this.writeAccess = ExpressionExtensions.isLeftHandSide(request.context);
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        HashSet<String> names = new HashSet<String>();
        IScope[] iScopeArray = this.subScopes;
        int n = this.subScopes.length;
        int n2 = 0;
        while (n2 < n) {
            IScope currSubScope = iScopeArray[n2];
            try {
                for (IEObjectDescription currDesc : currSubScope.getAllElements()) {
                    if (IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)currDesc)) continue;
                    String name = currDesc.getName().getLastSegment();
                    names.add(name);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            ++n2;
        }
        ArrayList<IEObjectDescription> descriptions = new ArrayList<IEObjectDescription>(names.size());
        for (String name : names) {
            IEObjectDescription description = this.getSingleLocalElementByName(QualifiedName.create((String)name));
            if (description == null || IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)description)) continue;
            descriptions.add(description);
        }
        return descriptions;
    }

    protected IEObjectDescription getSingleLocalElementByName(QualifiedName qualifiedName) {
        String name = qualifiedName.getLastSegment();
        TMember member = this.getOrCreateComposedMember(name);
        if (member == null) {
            return null;
        }
        if (this.isErrorPlaceholder((EObject)member)) {
            return this.createComposedMemberDescriptionWithErrors(EObjectDescription.create((String)member.getName(), (EObject)member));
        }
        IEObjectDescription description = this.getCheckedDescription(name, member);
        return description;
    }

    private TMember createComposedMember(String memberName) {
        Resource resource = EcoreUtilN4.getResource((EObject)this.request.context, (EObject[])new EObject[]{this.composedTypeRef});
        ComposedMemberInfoBuilder cmiBuilder = new ComposedMemberInfoBuilder();
        cmiBuilder.init(this.writeAccess, resource, this.ts);
        int idx = 0;
        while (idx < this.subScopes.length) {
            IScope subScope = this.subScopes[idx];
            TypeRef typeRef = (TypeRef)this.composedTypeRef.getTypeRefs().get(idx);
            Resource res = EcoreUtilN4.getResource((EObject)this.request.context, (EObject[])new EObject[]{this.composedTypeRef});
            RuleEnvironment GwithSubstitutions = this.ts.createRuleEnvironmentForContext(typeRef, res);
            TMember member = this.findMemberInSubScope(subScope, memberName);
            boolean structFieldInitMode = typeRef.getTypingStrategy() == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
            cmiBuilder.addMember(member, GwithSubstitutions, structFieldInitMode);
            ++idx;
        }
        ComposedMemberInfo cmi = cmiBuilder.get();
        ComposedMemberFactory cmf = this.getComposedMemberFactory(cmi);
        if (!cmf.isEmpty()) {
            TMember result = cmf.isValid() ? cmf.create(memberName) : this.createErrorPlaceholder(memberName);
            ComposedMemberCache cache = this.getOrCreateComposedMemberCache();
            if (cache != null) {
                EcoreUtilN4.doWithDeliver((boolean)false, () -> cache.getCachedComposedMembers().add((Object)result), (Object[])new Object[]{cache});
            }
            return result;
        }
        return null;
    }

    private TMember getOrCreateComposedMember(String memberName) {
        ComposedMemberCache cache = this.getOrCreateComposedMemberCache();
        if (cache != null) {
            for (TMember currM : cache.getCachedComposedMembers()) {
                if (!memberName.equals(currM.getName()) || !ComposedMemberScope.hasCorrectAccess(currM, this.writeAccess)) continue;
                return currM;
            }
        }
        return this.createComposedMember(memberName);
    }

    private ComposedMemberCache getOrCreateComposedMemberCache() {
        if (this.request.provideContainedMembers) {
            TModule module;
            MemberAccess contextCasted = (MemberAccess)this.request.context;
            ComposedMemberCache cache = contextCasted.getComposedMemberCache();
            if (cache != null && TypeCompareUtils.isEqual((TypeArgument)cache.getComposedTypeRef(), (TypeArgument)this.composedTypeRef)) {
                return cache;
            }
            Resource res = contextCasted.eResource();
            TModule tModule = module = res instanceof N4JSResource ? ((N4JSResource)res).getModule() : null;
            if (module != null) {
                for (ComposedMemberCache existingCache : module.getComposedMemberCaches()) {
                    if (!TypeCompareUtils.isEqual((TypeArgument)existingCache.getComposedTypeRef(), (TypeArgument)this.composedTypeRef)) continue;
                    return existingCache;
                }
                ComposedMemberCache cacheNew = TypesFactory.eINSTANCE.createComposedMemberCache();
                EcoreUtilN4.doWithDeliver((boolean)false, () -> {
                    cacheNew.setComposedTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)this.composedTypeRef));
                    module.getComposedMemberCaches().add((Object)cacheNew);
                    contextCasted.setComposedMemberCache(cacheNew);
                }, (Object[])new Object[]{module, contextCasted});
                return cacheNew;
            }
        }
        return null;
    }

    private TMember createErrorPlaceholder(String memberName) {
        if (this.writeAccess) {
            TSetter s = TypeUtils.createTSetter((String)memberName, null, (TypeRef)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
            s.setComposed(true);
            return s;
        }
        TGetter g = TypesFactory.eINSTANCE.createTGetter();
        g.setComposed(true);
        g.setName(memberName);
        g.setDeclaredTypeRef((TypeRef)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
        return g;
    }

    private boolean isErrorPlaceholder(EObject obj) {
        return obj != null && !obj.eIsProxy() && obj instanceof FieldAccessor && TypeUtils.getMemberTypeRef((TMember)((FieldAccessor)obj)) instanceof UnknownTypeRef;
    }

    private TMember findMemberInSubScope(IScope subScope, String name) {
        EObject objOrProxy;
        IEObjectDescription currElem = subScope.getSingleElement(QualifiedName.create((String)name));
        if (currElem != null && (objOrProxy = currElem.getEObjectOrProxy()) != null && !objOrProxy.eIsProxy() && objOrProxy instanceof TMember) {
            TMember currM = (TMember)objOrProxy;
            return currM;
        }
        return null;
    }

    private static boolean hasCorrectAccess(TMember currM, boolean writeAccess) {
        return !writeAccess && currM.isReadable() || writeAccess && currM.isWriteable();
    }

    public static final void clearCachedComposedMembers(EObject astElement) {
        Iterator iter = Iterators.concat((Iterator)Iterators.singletonIterator((Object)astElement), (Iterator)astElement.eAllContents());
        while (iter.hasNext()) {
            ComposedMemberCache cache;
            EObject currObj = (EObject)iter.next();
            if (!(currObj instanceof MemberAccess) || (cache = ((MemberAccess)currObj).getComposedMemberCache()) == null) continue;
            cache.getCachedComposedMembers().clear();
        }
    }
}

