/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.n4js.postprocessing.TypeProcessor;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.xsemantics.InternalTypeSystem;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xtext.service.OperationCanceledManager;

@Singleton
public class CustomInternalTypeSystem
extends InternalTypeSystem {
    @Inject
    private TypeProcessor typeProcessor;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public void checkAssignableTo(Object result, Class<?> destinationClass) {
        if (result == null || !this.isResultAssignableTo(result, destinationClass)) {
            throw this.newRuleFailedException(String.valueOf(this.stringRep(result)) + " cannot be assigned to " + this.stringRep(destinationClass));
        }
    }

    public RuleFailedException extractRuleFailedException(Exception e) {
        this.operationCanceledManager.propagateIfCancelException((Throwable)e);
        return super.extractRuleFailedException(e);
    }

    public void throwRuleFailedException(String message, String issue, Throwable t, ErrorInformation ... errorInformations) {
        this.operationCanceledManager.propagateIfCancelException(t);
        super.throwRuleFailedException(message, issue, t, errorInformations);
    }

    protected RuleFailedException createRuleFailedException(String message, String issue, Throwable t) {
        return new RuleFailedExceptionWithoutStacktrace(message, issue, t);
    }

    protected String stringRepForEnv(RuleEnvironment ruleEnvironment) {
        return "[...]";
    }

    @Override
    protected Result<TypeRef> typeInternal(RuleEnvironment _environment_, RuleApplicationTrace _trace_, TypableElement expression) {
        return this.typeProcessor.getType(_environment_, _trace_, expression);
    }

    public Result<TypeRef> use_type_judgment_from_PostProcessors(RuleEnvironment _environment_, RuleApplicationTrace _trace_, TypableElement expression) {
        return super.typeInternal(_environment_, _trace_, expression);
    }

    public static class RuleFailedExceptionWithoutStacktrace
    extends RuleFailedException {
        public RuleFailedExceptionWithoutStacktrace() {
        }

        public RuleFailedExceptionWithoutStacktrace(String arg0) {
            super(arg0);
        }

        public RuleFailedExceptionWithoutStacktrace(String failed, String issue2, Throwable t) {
            super(failed, issue2, t);
        }

        public RuleFailedExceptionWithoutStacktrace(String arg0, RuleFailedException previous) {
            super(arg0, previous);
        }

        public Throwable fillInStackTrace() {
            return this;
        }

        public StackTraceElement[] getStackTrace() {
            return new StackTraceElement[0];
        }
    }
}

