/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.TypeSystemHelperStrategy;
import org.eclipse.xsemantics.runtime.RuleEnvironment;

public class DerivationComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;

    public FunctionTypeExpression createSubstitutionOfFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef F) {
        TypeRef _returnTypeRef;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        FunctionTypeExpression result = TypeRefsFactory.eINSTANCE.createFunctionTypeExpression();
        result.setBinding(true);
        result.setDeclaredType(F.getFunctionType());
        EList _typeVars = F.getTypeVars();
        for (TypeVariable currTV : _typeVars) {
            boolean _tripleEquals;
            Object _get = G.get((Object)currTV);
            boolean bl = _tripleEquals = _get == null;
            if (!_tripleEquals) continue;
            EList _unboundTypeVars = result.getUnboundTypeVars();
            _unboundTypeVars.add((Object)currTV);
            this.performSubstitutionOnUpperBounds(G, F, currTV, result);
        }
        TypeRef _declaredThisType = F.getDeclaredThisType();
        boolean bl = _tripleNotEquals = _declaredThisType != null;
        if (_tripleNotEquals) {
            TypeRef resultDeclaredThisType = this.ts.substTypeVariablesInTypeRef(G, F.getDeclaredThisType());
            result.setDeclaredThisType((TypeRef)TypeUtils.copy((EObject)resultDeclaredThisType));
        }
        boolean bl2 = _tripleNotEquals_1 = (_returnTypeRef = F.getReturnTypeRef()) != null;
        if (_tripleNotEquals_1) {
            TypeRef resultReturnTypeRef = this.ts.substTypeVariablesInTypeRef(G, F.getReturnTypeRef());
            result.setReturnTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)resultReturnTypeRef));
        }
        result.setReturnValueMarkedOptional(F.isReturnValueOptional());
        EList _fpars = F.getFpars();
        for (TFormalParameter fpar : _fpars) {
            if (fpar != null) {
                boolean _tripleNotEquals_2;
                TFormalParameter newPar = TypesFactory.eINSTANCE.createTFormalParameter();
                newPar.setName(fpar.getName());
                newPar.setVariadic(fpar.isVariadic());
                newPar.setHasInitializerAssignment(fpar.isHasInitializerAssignment());
                TypeRef _typeRef = fpar.getTypeRef();
                boolean bl3 = _tripleNotEquals_2 = _typeRef != null;
                if (_tripleNotEquals_2) {
                    TypeRef resultParTypeRef = this.ts.substTypeVariablesInTypeRef(G, fpar.getTypeRef());
                    newPar.setTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)resultParTypeRef));
                }
                EList _fpars_1 = result.getFpars();
                _fpars_1.add((Object)newPar);
                continue;
            }
            result.getFpars().add(null);
        }
        TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)F);
        return result;
    }

    public FunctionTypeExpression createUpperBoundOfFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef F) {
        return this.createBoundOfFunctionTypeExprOrRef(G, F, BoundType.UPPER);
    }

    public FunctionTypeExpression createLowerBoundOfFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef F) {
        return this.createBoundOfFunctionTypeExprOrRef(G, F, BoundType.LOWER);
    }

    private FunctionTypeExpression createBoundOfFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef F, BoundType boundType) {
        TypeRef _returnTypeRef;
        boolean _tripleNotEquals_1;
        TypeRef _declaredThisType;
        boolean _tripleNotEquals;
        FunctionTypeExpression result = TypeRefsFactory.eINSTANCE.createFunctionTypeExpression();
        result.setBinding(true);
        result.setDeclaredType(F.getFunctionType());
        EList _unboundTypeVars = result.getUnboundTypeVars();
        EList _typeVars = F.getTypeVars();
        Iterables.addAll((Collection)_unboundTypeVars, (Iterable)_typeVars);
        if (F instanceof FunctionTypeExpression) {
            EList _unboundTypeVarsUpperBounds = result.getUnboundTypeVarsUpperBounds();
            Collection _copyAll = TypeUtils.copyAll((Collection)((FunctionTypeExpression)F).getUnboundTypeVarsUpperBounds());
            Iterables.addAll((Collection)_unboundTypeVarsUpperBounds, (Iterable)_copyAll);
        }
        boolean bl = _tripleNotEquals = (_declaredThisType = F.getDeclaredThisType()) != null;
        if (_tripleNotEquals) {
            result.setDeclaredThisType((TypeRef)TypeUtils.copy((EObject)F.getDeclaredThisType()));
        }
        boolean bl2 = _tripleNotEquals_1 = (_returnTypeRef = F.getReturnTypeRef()) != null;
        if (_tripleNotEquals_1) {
            TypeRef _switchResult = null;
            if (boundType != null) {
                switch (boundType) {
                    case UPPER: {
                        _switchResult = (TypeRef)this.ts.upperBound(G, (TypeArgument)F.getReturnTypeRef()).getValue();
                        break;
                    }
                    case LOWER: {
                        _switchResult = (TypeRef)this.ts.lowerBound(G, (TypeArgument)F.getReturnTypeRef()).getValue();
                        break;
                    }
                }
            }
            TypeRef resultReturnTypeRef = _switchResult;
            result.setReturnTypeRef((TypeRef)TypeUtils.copyIfContained(resultReturnTypeRef));
        }
        EList _fpars = F.getFpars();
        for (TFormalParameter fpar : _fpars) {
            if (fpar != null) {
                boolean _tripleNotEquals_2;
                TFormalParameter newPar = TypesFactory.eINSTANCE.createTFormalParameter();
                newPar.setName(fpar.getName());
                newPar.setVariadic(fpar.isVariadic());
                newPar.setHasInitializerAssignment(fpar.isHasInitializerAssignment());
                TypeRef _typeRef = fpar.getTypeRef();
                boolean bl3 = _tripleNotEquals_2 = _typeRef != null;
                if (_tripleNotEquals_2) {
                    TypeRef _switchResult_1 = null;
                    if (boundType != null) {
                        switch (boundType) {
                            case UPPER: {
                                _switchResult_1 = (TypeRef)this.ts.lowerBound(G, (TypeArgument)fpar.getTypeRef()).getValue();
                                break;
                            }
                            case LOWER: {
                                _switchResult_1 = (TypeRef)this.ts.upperBound(G, (TypeArgument)fpar.getTypeRef()).getValue();
                                break;
                            }
                        }
                    }
                    TypeRef resultParTypeRef = _switchResult_1;
                    newPar.setTypeRef((TypeRef)TypeUtils.copyIfContained(resultParTypeRef));
                }
                EList _fpars_1 = result.getFpars();
                _fpars_1.add((Object)newPar);
                continue;
            }
            result.getFpars().add(null);
        }
        TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)F);
        return result;
    }

    private void performSubstitutionOnUpperBounds(RuleEnvironment G, FunctionTypeExprOrRef F, TypeVariable currTV, FunctionTypeExpression result) {
        TypeRef currTV_declUB = currTV.getDeclaredUpperBound();
        if (currTV_declUB != null) {
            boolean unchanged;
            TypeRef oldUB = F.getTypeVarUpperBound(currTV);
            TypeRef newUB = this.ts.substTypeVariablesInTypeRef(G, oldUB);
            boolean bl = unchanged = newUB == currTV_declUB;
            if (!unchanged) {
                int idx = result.getUnboundTypeVars().indexOf((Object)currTV);
                while (result.getUnboundTypeVarsUpperBounds().size() < idx) {
                    result.getUnboundTypeVarsUpperBounds().add(null);
                }
                TypeRef ubSubst = newUB;
                EList _unboundTypeVarsUpperBounds = result.getUnboundTypeVarsUpperBounds();
                _unboundTypeVarsUpperBounds.add((Object)ubSubst);
            }
        }
    }

    private static enum BoundType {
        UPPER,
        LOWER;

    }
}

