/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.TypeSystemHelperStrategy;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MeetComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;

    public TypeRef meet(RuleEnvironment G, Iterable<? extends TypeRef> typeRefs) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(typeRefs);
        if (_isNullOrEmpty) {
            return null;
        }
        Functions.Function1 _function = it -> this.flattenTypeRefs((TypeRef)it);
        Iterable flatTypeRefs = Iterables.concat((Iterable)IterableExtensions.map(typeRefs, (Functions.Function1)_function));
        TypeRef meet = null;
        for (TypeRef tr : flatTypeRefs) {
            boolean _not;
            if (meet == null) {
                meet = (TypeRef)TypeUtils.copyIfContained((EObject)tr);
                continue;
            }
            boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)tr, (TypeArgument)meet);
            if (_subtypeSucceeded) {
                meet = (TypeRef)TypeUtils.copyIfContained((EObject)tr);
                continue;
            }
            boolean _subtypeSucceeded_1 = this.ts.subtypeSucceeded(G, (TypeArgument)meet, (TypeArgument)tr);
            boolean bl = _not = !_subtypeSucceeded_1;
            if (!_not) continue;
            meet = this.intersectRelaxed(G, meet, tr);
        }
        return meet;
    }

    private Iterable<? extends TypeRef> _flattenTypeRefs(TypeRef ref) {
        return Collections.singleton(ref);
    }

    private Iterable<? extends TypeRef> _flattenTypeRefs(ComposedTypeRef ref) {
        return ref.getTypeRefs();
    }

    @VisibleForTesting
    public TypeRef intersectRelaxed(RuleEnvironment G, TypeRef ... typeRefs) {
        boolean _equals;
        Functions.Function1 _function_1;
        LinkedList<TypeRef> intersectTRs = new LinkedList<TypeRef>();
        Functions.Function1 _function = it -> this.flattenIntersectionTypes((TypeRef)it);
        Iterable flattenedTypeRefs = Iterables.concat((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)typeRefs)), (Functions.Function1)_function));
        TypeRef containedAny = (TypeRef)IterableExtensions.findFirst((Iterable)flattenedTypeRefs, (Functions.Function1)(_function_1 = it -> it != null && it.isTopType()));
        if (containedAny != null) {
            intersectTRs.add(containedAny);
        } else {
            intersectTRs.addAll(this._typeSystemHelper.getSubtypesOnly(G, (TypeRef[])Conversions.unwrapArray((Object)flattenedTypeRefs, TypeRef.class)));
        }
        int _size = intersectTRs.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            TypeRef tR = (TypeRef)intersectTRs.get(0);
            return (TypeRef)TypeUtils.copyIfContained((EObject)tR);
        }
        IntersectionTypeExpression intersection = TypeRefsFactory.eINSTANCE.createIntersectionTypeExpression();
        for (TypeRef s : intersectTRs) {
            intersection.getTypeRefs().add((Object)((TypeRef)TypeUtils.copyIfContained((EObject)s)));
        }
        return intersection;
    }

    private Iterable<TypeRef> flattenIntersectionTypes(TypeRef typeRef) {
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (typeRef instanceof IntersectionTypeExpression) {
            _matched = true;
            Functions.Function1 _function = it -> this.flattenIntersectionTypes((TypeRef)it);
            _switchResult = Iterables.concat((Iterable)ListExtensions.map((List)((IntersectionTypeExpression)typeRef).getTypeRefs(), (Functions.Function1)_function));
        }
        if (!_matched) {
            _switchResult = Collections.singleton(typeRef);
        }
        return _switchResult;
    }

    private Iterable<? extends TypeRef> flattenTypeRefs(TypeRef ref) {
        if (ref instanceof ComposedTypeRef) {
            return this._flattenTypeRefs((ComposedTypeRef)ref);
        }
        if (ref != null) {
            return this._flattenTypeRefs(ref);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ref).toString());
    }
}

