/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4idl.migrations.MigrationSwitchComputer;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.VersionedParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMigratable;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.ts.versions.MigratableUtils;
import org.eclipse.n4js.ts.versions.VersionableUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.utils.collections.Collections2;
import org.eclipse.n4js.utils.collections.Iterables2;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class N4IDLMigrationValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private JavaScriptVariantHelper variantHelper;
    @Inject
    private N4JSTypeSystem typeSystem;
    @Inject
    private MigrationSwitchComputer switchComputer;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkMigration(FunctionDeclaration functionDeclaration) {
        boolean _not_2;
        boolean _not_1;
        boolean _tripleEquals;
        boolean _not;
        boolean _allowVersionedTypes = this.variantHelper.allowVersionedTypes((EObject)functionDeclaration);
        boolean bl = _not = !_allowVersionedTypes;
        if (_not) {
            return;
        }
        if (functionDeclaration == null || functionDeclaration.getName() == null) {
            return;
        }
        Block _body = functionDeclaration.getBody();
        boolean bl2 = _tripleEquals = _body == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isMigrationDefinition = MigrationUtils.isMigrationDefinition((FunctionDefinition)functionDeclaration);
        boolean bl3 = _not_1 = !_isMigrationDefinition;
        if (_not_1) {
            return;
        }
        TFunction _definedFunction = functionDeclaration.getDefinedFunction();
        boolean bl4 = _not_2 = !(_definedFunction instanceof TMigration);
        if (_not_2) {
            String _name = functionDeclaration.getName();
            String _plus = "FunctionDeclaration " + _name;
            String _plus_1 = String.valueOf(_plus) + " does not refer to a valid TMigration type model instance";
            throw new IllegalStateException(_plus_1);
        }
        TFunction _definedFunction_1 = functionDeclaration.getDefinedFunction();
        TMigration migration = (TMigration)_definedFunction_1;
        if (this.holdsExplicitlyDeclaresReturnType(functionDeclaration, migration) && this.holdsMigrationHasSourceAndTargetTypes(migration) && this.holdsNoComposedSourceAndTargetTypes(migration)) {
            boolean _isEmpty = migration.getTypeVars().isEmpty();
            if (_isEmpty) {
                boolean _holdsMigrationHasDifferentSourceAndTargetVersions;
                boolean _and = false;
                _and = !this.holdsHasPrincipalArgumentType(migration) || !this.holdsMigrationHasValidSourceAndTargetVersion(migration) || !this.holdsMigrationHasVersionExclusiveSourceAndTargetVersion(migration) ? false : (_holdsMigrationHasDifferentSourceAndTargetVersions = this.holdsMigrationHasDifferentSourceAndTargetVersions(functionDeclaration, migration));
            }
            return;
        }
    }

    private boolean holdsExplicitlyDeclaresReturnType(FunctionDeclaration migrationDeclaration, TMigration tMigration) {
        boolean _tripleEquals;
        TypeRef _returnTypeRef = migrationDeclaration.getReturnTypeRef();
        boolean bl = _tripleEquals = _returnTypeRef == null;
        if (_tripleEquals) {
            this.addIssue(IssueCodes.getMessageForIDL_MIGRATION_MUST_EXPLICITLY_DECLARE_RETURN_TYPE(), (EObject)migrationDeclaration, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "IDL_MIGRATION_MUST_EXPLICITLY_DECLARE_RETURN_TYPE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsMigrationHasSourceAndTargetTypes(TMigration migration) {
        if (migration.getSourceTypeRefs().isEmpty() || migration.getTargetTypeRefs().isEmpty() || migration.getTargetTypeRefs().size() == 1 && this.isVoidTypeRef((TypeRef)IterableExtensions.head((Iterable)migration.getTargetTypeRefs()))) {
            this.addIssue(IssueCodes.getMessageForIDL_MIGRATION_MUST_DECLARE_IN_AND_OUTPUT(), migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "IDL_MIGRATION_MUST_DECLARE_IN_AND_OUTPUT", new String[0]);
            return false;
        }
        Functions.Function1 _function = p -> this.isMigrationContextTypeRef(p.getTypeRef());
        Consumer<TFormalParameter> _function_1 = p -> this.addIssueToMigrationTypeRef(IssueCodes.getMessageForIDL_MIGRATION_NO_EXPLICIT_CONTEXT_PARAMETER(), p.getTypeRef(), "IDL_MIGRATION_NO_EXPLICIT_CONTEXT_PARAMETER");
        IterableExtensions.filter((Iterable)migration.getFpars(), (Functions.Function1)_function).forEach(_function_1);
        return true;
    }

    private boolean holdsNoComposedSourceAndTargetTypes(TMigration migration) {
        Function<TypeRef, Boolean> _function = ref -> this.holdsIsNotComposedTypeRef(migration, (TypeRef)ref);
        boolean sourceTypesHoldNoComposedTypes = this.allHold((Iterable)migration.getSourceTypeRefs(), (Function)_function);
        Function<TypeRef, Boolean> _function_1 = ref -> this.holdsIsNotComposedTypeRef(migration, (TypeRef)ref);
        boolean targetTypesHoldNoComposedTypes = this.allHold((Iterable)migration.getTargetTypeRefs(), (Function)_function_1);
        return sourceTypesHoldNoComposedTypes && targetTypesHoldNoComposedTypes;
    }

    private <T> boolean allHold(Iterable<T> elements, Function<T, Boolean> constraintChecker) {
        Functions.Function2 _function = (previousResult, element) -> (Boolean)constraintChecker.apply(element) != false && previousResult != false;
        return (Boolean)IterableExtensions.fold(elements, (Object)true, (Functions.Function2)_function);
    }

    private boolean holdsHasPrincipalArgumentType(TMigration migration) {
        boolean _tripleEquals;
        TMigratable _principalArgumentType = migration.getPrincipalArgumentType();
        boolean bl = _tripleEquals = _principalArgumentType == null;
        if (_tripleEquals) {
            this.addIssueToMultiValueFeature(IssueCodes.getMessageForIDL_MIGRATION_HAS_PRINCIPAL_ARGUMENT(), migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__FPARS, "IDL_MIGRATION_HAS_PRINCIPAL_ARGUMENT", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsIsNotComposedTypeRef(TMigration migration, TypeRef typeRef) {
        if (typeRef instanceof ComposedTypeRef) {
            this.addIssueToMigrationTypeRef(IssueCodes.getMessageForIDL_MIGRATION_SIGNATURE_NO_COMPOSED_TYPES(), typeRef, "IDL_MIGRATION_SIGNATURE_NO_COMPOSED_TYPES");
            return false;
        }
        return true;
    }

    private boolean holdsMigrationHasValidSourceAndTargetVersion(TMigration migration) {
        boolean _equals_1;
        boolean _equals;
        int _sourceVersion = migration.getSourceVersion();
        boolean bl = _equals = _sourceVersion == 0;
        if (_equals) {
            String message = IssueCodes.getMessageForIDL_MIGRATION_VERSION_CANNOT_BE_INFERRED("source", migration.getName());
            this.addIssueToMultiValueFeature(message, migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__FPARS, "IDL_MIGRATION_VERSION_CANNOT_BE_INFERRED", new String[0]);
            return false;
        }
        int _targetVersion = migration.getTargetVersion();
        boolean bl2 = _equals_1 = _targetVersion == 0;
        if (_equals_1) {
            String message_1 = IssueCodes.getMessageForIDL_MIGRATION_VERSION_CANNOT_BE_INFERRED("target", migration.getName());
            this.addIssue(message_1, migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__RETURN_TYPE_REF, "IDL_MIGRATION_VERSION_CANNOT_BE_INFERRED", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsMigrationHasVersionExclusiveSourceAndTargetVersion(TMigration migration) {
        boolean _not_1;
        boolean _not;
        boolean _isHasDeclaredSourceAndTargetVersion = migration.isHasDeclaredSourceAndTargetVersion();
        if (_isHasDeclaredSourceAndTargetVersion) {
            return true;
        }
        boolean _isVersionExclusive = this.isVersionExclusive((Collection<TypeRef>)migration.getSourceTypeRefs());
        boolean bl = _not = !_isVersionExclusive;
        if (_not) {
            String message = IssueCodes.getMessageForIDL_MIGRATION_AMBIGUOUS_VERSION("source", migration.getName());
            this.addIssueToMultiValueFeature(message, migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__FPARS, "IDL_MIGRATION_VERSION_CANNOT_BE_INFERRED", new String[0]);
            return false;
        }
        boolean _isVersionExclusive_1 = this.isVersionExclusive((Collection<TypeRef>)migration.getTargetTypeRefs());
        boolean bl2 = _not_1 = !_isVersionExclusive_1;
        if (_not_1) {
            String message_1 = IssueCodes.getMessageForIDL_MIGRATION_AMBIGUOUS_VERSION("target", migration.getName());
            this.addIssue(message_1, migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__RETURN_TYPE_REF, "IDL_MIGRATION_VERSION_CANNOT_BE_INFERRED", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsMigrationHasDifferentSourceAndTargetVersions(FunctionDeclaration declaration, TMigration migration) {
        int _targetVersion;
        boolean _equals;
        int _sourceVersion = migration.getSourceVersion();
        boolean bl = _equals = _sourceVersion == (_targetVersion = migration.getTargetVersion());
        if (_equals) {
            String msg = IssueCodes.getMessageForIDL_MIGRATION_SAME_SOURCE_AND_TARGET_VERSION(migration.getName(), migration.getSourceVersion());
            boolean _isHasDeclaredSourceAndTargetVersion = migration.isHasDeclaredSourceAndTargetVersion();
            if (_isHasDeclaredSourceAndTargetVersion) {
                Annotation migrationAnno = AnnotationDefinition.MIGRATION.getAnnotation((AnnotableElement)declaration);
                this.addIssueToMultiValueFeature(msg, (EObject)migrationAnno, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__ARGS, "IDL_MIGRATION_SAME_SOURCE_AND_TARGET_VERSION", new String[0]);
                return false;
            }
            this.addIssue(msg, (EObject)declaration, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "IDL_MIGRATION_SAME_SOURCE_AND_TARGET_VERSION", new String[0]);
            return false;
        }
        return true;
    }

    private boolean isVoidTypeRef(TypeRef typeRef) {
        BuiltInTypeScope builtInTypes = BuiltInTypeScope.get((ResourceSet)typeRef.eResource().getResourceSet());
        Type _declaredType = typeRef.getDeclaredType();
        VoidType _voidType = builtInTypes.getVoidType();
        return Objects.equal((Object)_declaredType, (Object)_voidType);
    }

    private boolean isMigrationContextTypeRef(TypeRef typeRef) {
        BuiltInTypeScope builtInTypes = BuiltInTypeScope.get((ResourceSet)typeRef.eResource().getResourceSet());
        Type _declaredType = typeRef.getDeclaredType();
        TInterface _migrationContextType = builtInTypes.getMigrationContextType();
        return Objects.equal((Object)_declaredType, (Object)_migrationContextType);
    }

    @Check
    public void checkMigratableTypeDeclaration(N4TypeDeclaration typeDeclaration) {
        Type declaredType = typeDeclaration.getDefinedType();
        if (declaredType == null) {
            return;
        }
        if (!(declaredType instanceof TMigratable)) {
            return;
        }
        TMigratable migratable = (TMigratable)declaredType;
        Functions.Function1 _function = it -> {
            int _targetVersion = it.getTargetVersion();
            int _size = it.getSourceTypeRefs().size();
            return Pair.of((Object)_targetVersion, (Object)_size);
        };
        Functions.Function2 _function_1 = (groupKey, migrations) -> (Integer)groupKey.getKey() > 0 && (Integer)groupKey.getValue() > 0 && migrations.size() > 0;
        Map migrationGroups = MapExtensions.filter((Map)IterableExtensions.groupBy((Iterable)migratable.getMigrations(), (Functions.Function1)_function), (Functions.Function2)_function_1);
        BiConsumer<Pair, List> _function_2 = (groupKey, migrations) -> this.holdsTypeSwitchDistinguishable((Iterable<TMigration>)migrations);
        migrationGroups.forEach(_function_2);
    }

    private RuleEnvironment ruleEnvironment(TypeRef ref) {
        return this.typeSystem.createRuleEnvironmentForContext(ref, ref.eResource());
    }

    private static <T1, T2> void forPair(Stream<Pair<T1, T2>> stream, Procedures.Procedure2<T1, T2> procedure) {
        Consumer<Pair> _function = pair -> procedure.apply(pair.getKey(), pair.getValue());
        stream.forEach(_function);
    }

    private boolean areEqualTypes(RuleEnvironment ruleEnv, Iterable<TypeRef> left, Iterable<TypeRef> right) {
        int _size_1;
        boolean _notEquals;
        int _size = IterableExtensions.size(left);
        boolean bl = _notEquals = _size != (_size_1 = IterableExtensions.size(right));
        if (_notEquals) {
            return false;
        }
        Functions.Function1 _function = pair -> {
            TypeRef r;
            TypeRef l = (TypeRef)pair.getKey();
            Result<Boolean> subtypingResult = this.typeSystem.equaltype(ruleEnv, (TypeArgument)l, (TypeArgument)(r = (TypeRef)pair.getValue()));
            return subtypingResult.failed() || (Boolean)subtypingResult.getValue() == false;
        };
        Pair firstNonSubtype = (Pair)IterableExtensions.findFirst((Iterable)Iterables2.align(left, right), (Functions.Function1)_function);
        return firstNonSubtype == null;
    }

    private boolean holdsTypeSwitchDistinguishable(Iterable<TMigration> migrations) {
        Functions.Function1 _function = migration -> {
            List<TypeRef> _switchRecognizableSourceTypeRefs = this.getSwitchRecognizableSourceTypeRefs((TMigration)migration);
            return Pair.of((Object)migration, _switchRecognizableSourceTypeRefs);
        };
        List migrationAndSwitchTypes = IterableExtensions.toList((Iterable)IterableExtensions.map(migrations, (Functions.Function1)_function));
        HashMap conflictGroups = new HashMap();
        Procedures.Procedure2 _function_1 = (m1, m2) -> {
            TMigration tMigration1 = (TMigration)m1.getKey();
            List switchTypes1 = (List)m1.getValue();
            TMigration tMigration2 = (TMigration)m2.getKey();
            List switchTypes2 = (List)m2.getValue();
            if (switchTypes1.size() == 0 || switchTypes2.size() == 0) {
                return;
            }
            RuleEnvironment ruleEnv = this.ruleEnvironment((TypeRef)IterableExtensions.head((Iterable)tMigration1.getSourceTypeRefs()));
            boolean _areEqualTypes = this.areEqualTypes(ruleEnv, switchTypes1, switchTypes2);
            if (_areEqualTypes) {
                this.addMigrationConflict(conflictGroups, tMigration1, tMigration2);
            }
        };
        N4IDLMigrationValidator.forPair(Collections2.pairs((Collection)migrationAndSwitchTypes), _function_1);
        Consumer<Set> _function_2 = conflictGroup -> this.addIssueMigrationConflict((Iterable<TMigration>)conflictGroup);
        IterableExtensions.toSet(conflictGroups.values()).forEach(_function_2);
        return conflictGroups.isEmpty();
    }

    private List<TypeRef> getSwitchRecognizableSourceTypeRefs(TMigration migration) {
        int _size_1;
        boolean _notEquals;
        Functions.Function1 _function = s -> {
            TypeRef _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = this.switchComputer.toSwitchRecognizableTypeRef(this.ruleEnvironment((TypeRef)s), (TypeRef)s);
            }
            catch (Throwable _t) {
                if (_t instanceof MigrationSwitchComputer.UnhandledTypeRefException) {
                    MigrationSwitchComputer.UnhandledTypeRefException e = (MigrationSwitchComputer.UnhandledTypeRefException)_t;
                    Functions.Function1 _function_1 = par -> {
                        TypeRef _typeRef = par.getTypeRef();
                        return Objects.equal((Object)_typeRef, (Object)s);
                    };
                    this.addUnsupportedParameterTypeRefIssue((TFormalParameter)IterableExtensions.findFirst((Iterable)migration.getFpars(), (Functions.Function1)_function_1));
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return _xtrycatchfinallyexpression;
        };
        List refs = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)migration.getSourceTypeRefs(), (Functions.Function1)_function)));
        int _size = refs.size();
        boolean bl = _notEquals = _size != (_size_1 = migration.getSourceTypeRefs().size());
        if (_notEquals) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return refs;
    }

    private void addUnsupportedParameterTypeRefIssue(TFormalParameter tParam) {
        EObject _astElement = tParam.getAstElement();
        TypeRef astTypeRef = ((FormalParameter)_astElement).getDeclaredTypeRef();
        if (astTypeRef instanceof ComposedTypeRef) {
            return;
        }
        this.addIssue(IssueCodes.getMessageForIDL_MIGRATION_UNSUPPORTED_PARAMETER_TYPE(astTypeRef.getTypeRefAsString()), (EObject)astTypeRef, "IDL_MIGRATION_UNSUPPORTED_PARAMETER_TYPE");
    }

    private void addMigrationConflict(Map<TMigration, Set<TMigration>> conflictGroups, TMigration m1, TMigration m2) {
        HashSet _hashSet = new HashSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TMigration[]{m1})));
        Set mergedGroup = conflictGroups.getOrDefault(m1, _hashSet);
        boolean _contains = mergedGroup.contains(m2);
        if (_contains) {
            return;
        }
        HashSet _hashSet_1 = new HashSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TMigration[]{m2})));
        mergedGroup.addAll(conflictGroups.getOrDefault(m2, _hashSet_1));
        conflictGroups.put(m1, mergedGroup);
        conflictGroups.put(m2, mergedGroup);
    }

    private void addIssueMigrationConflict(Iterable<TMigration> migrations) {
        boolean _lessEqualsThan;
        int _size = IterableExtensions.size(migrations);
        boolean bl = _lessEqualsThan = _size <= 1;
        if (_lessEqualsThan) {
            return;
        }
        Consumer<TMigration> _function = m -> {
            String argumentDescription = MigratableUtils.getMigrationArgumentsDescription((List)m.getSourceTypeRefs());
            Functions.Function1 _function_1 = other -> !Objects.equal((Object)other, (Object)m);
            String conflictingMigrationsDescription = this.listOrSingleMigrationDescription(IterableExtensions.filter((Iterable)migrations, (Functions.Function1)_function_1));
            String msg = IssueCodes.getMessageForIDL_MIGRATION_CONFLICT_WITH(m.getName(), argumentDescription, m.getTargetVersion(), conflictingMigrationsDescription);
            this.addIssue(msg, m.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "IDL_MIGRATION_CONFLICT_WITH", new String[0]);
        };
        migrations.forEach(_function);
    }

    private String listOrSingleMigrationDescription(Iterable<TMigration> migrations) {
        boolean _equals;
        int _size = IterableExtensions.size(migrations);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return ((TMigration)IterableExtensions.head(migrations)).getMigrationAsString();
        }
        Functions.Function1 _function = m -> {
            String _migrationAsString = m.getMigrationAsString();
            return "\n\t - " + _migrationAsString;
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map(migrations, (Functions.Function1)_function), (CharSequence)", ");
    }

    private boolean isVersionExclusive(Collection<TypeRef> typeRefs) {
        Function<TypeRef, Stream> _function = ref -> VersionableUtils.streamVersionedSubReferences((TypeRef)ref);
        ToIntFunction<VersionedParameterizedTypeRef> _function_1 = versionedRef -> versionedRef.getVersion();
        int[] versions = typeRefs.stream().flatMap(_function).mapToInt(_function_1).distinct().limit(2L).toArray();
        int _size = ((List)Conversions.doWrapArray((Object)versions)).size();
        return _size == 1;
    }

    private void addIssueToMigrationTypeRef(String message, TypeRef typeRef, String issueCode) {
        EObject _eContainer;
        TMigration migration = (TMigration)EcoreUtil2.getContainerOfType((EObject)typeRef, TMigration.class);
        if (migration == null) {
            this.addIssue(message, (EObject)typeRef, issueCode);
        }
        if ((_eContainer = typeRef.eContainer()) instanceof TFormalParameter) {
            int parameterIndex = migration.getFpars().indexOf((Object)typeRef.eContainer());
            this.addIssue(message, migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__FPARS, parameterIndex, issueCode, new String[0]);
        } else {
            EObject _eContainer_1 = typeRef.eContainer();
            if (_eContainer_1 instanceof TMigration) {
                this.addIssue(message, migration.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DEFINITION__RETURN_TYPE_REF, issueCode, new String[0]);
            } else {
                this.addIssue(message, (EObject)typeRef, issueCode);
            }
        }
    }
}

