/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.StaticPolyfillHelper;
import org.eclipse.n4js.utils.StructuralTypesHelper;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class N4JSAccessModifierValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    protected N4JSTypeSystem ts;
    @Inject
    protected ContainerTypesHelper containerTypesHelper;
    @Inject
    private StructuralTypesHelper structuralTypesHelper;
    @Inject
    private StaticPolyfillHelper staticPolyfillHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkExportedWhenVisibilityHigherThanPrivate(TypeDefiningElement typeDefiningElement) {
        boolean _not;
        boolean _requireCheckExportedWhenVisibilityHigherThanPrivate = this.jsVariantHelper.requireCheckExportedWhenVisibilityHigherThanPrivate((EObject)typeDefiningElement);
        boolean bl = _not = !_requireCheckExportedWhenVisibilityHigherThanPrivate;
        if (_not) {
            return;
        }
        if (typeDefiningElement instanceof ObjectLiteral) {
            return;
        }
        if (typeDefiningElement instanceof NamespaceImportSpecifier) {
            return;
        }
        Type type = typeDefiningElement.getDefinedType();
        if (type != null && !type.isExported() && type.getTypeAccessModifier().ordinal() > TypeAccessModifier.PRIVATE.ordinal() && type instanceof SyntaxRelatedTElement) {
            boolean _tripleNotEquals;
            EObject _astElement = ((SyntaxRelatedTElement)type).getAstElement();
            boolean bl2 = _tripleNotEquals = _astElement != null;
            if (_tripleNotEquals) {
                String message = IssueCodes.getMessageForCLF_NOT_EXPORTED_NOT_PRIVATE(this.keywordProvider.keyword(type), this.keywordProvider.keyword(type.getTypeAccessModifier()));
                Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature(((SyntaxRelatedTElement)type).getAstElement());
                this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_NOT_EXPORTED_NOT_PRIVATE", new String[0]);
            }
        }
    }

    @Check
    public void checkInternalUsedOnlyWithPublicAndProtected(ExportableElement exportableElement) {
        Annotation annotation;
        EObject parent = exportableElement.eContainer();
        Annotation _xifexpression = null;
        if (exportableElement instanceof AnnotableElement) {
            _xifexpression = AnnotationDefinition.INTERNAL.getAnnotation((AnnotableElement)exportableElement);
        }
        if ((annotation = _xifexpression) == null) {
            Annotation _xifexpression_1 = null;
            if (parent instanceof ExportDeclaration) {
                _xifexpression_1 = AnnotationDefinition.INTERNAL.getAnnotation((AnnotableElement)parent);
            }
            annotation = _xifexpression_1;
        }
        if (annotation != null) {
            TypeAccessModifier typeAccessModifier;
            TypeAccessModifier _typeAccessModifier;
            Type _definedType;
            TypeAccessModifier _switchResult = null;
            ExportableElement it = exportableElement;
            boolean _matched = false;
            if (it instanceof VariableStatement) {
                _matched = true;
                ExportedVariableDeclaration _head = (ExportedVariableDeclaration)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((VariableStatement)it).getVarDecl(), ExportedVariableDeclaration.class));
                TVariable _definedVariable = null;
                if (_head != null) {
                    _definedVariable = _head.getDefinedVariable();
                }
                TypeAccessModifier _typeAccessModifier2 = null;
                if (_definedVariable != null) {
                    _typeAccessModifier2 = _definedVariable.getTypeAccessModifier();
                }
                _switchResult = _typeAccessModifier2;
            }
            if (!_matched && it instanceof FunctionDeclaration) {
                _matched = true;
                _definedType = ((FunctionDeclaration)it).getDefinedType();
                _typeAccessModifier = null;
                if (_definedType != null) {
                    _typeAccessModifier = _definedType.getTypeAccessModifier();
                }
                _switchResult = _typeAccessModifier;
            }
            if (!_matched && it instanceof TypeDefiningElement) {
                _matched = true;
                _definedType = ((TypeDefiningElement)it).getDefinedType();
                _typeAccessModifier = null;
                if (_definedType != null) {
                    _typeAccessModifier = _definedType.getTypeAccessModifier();
                }
                _switchResult = _typeAccessModifier;
            }
            if (!_matched) {
                _switchResult = null;
            }
            if ((typeAccessModifier = _switchResult) != null && typeAccessModifier.ordinal() <= TypeAccessModifier.PROJECT.ordinal()) {
                String message = IssueCodes.getMessageForCLF_LOW_ACCESSOR_WITH_INTERNAL(this.keywordProvider.keyword(exportableElement), this.keywordProvider.keyword(typeAccessModifier));
                Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)exportableElement);
                this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_LOW_ACCESSOR_WITH_INTERNAL", new String[0]);
            }
        }
    }

    @Check
    public void checkTypeRefOptionalFlag(TypeRef typeRef) {
        EObject parent;
        boolean isLegalUseOfOptional;
        boolean _isFollowedByQuestionMark = typeRef.isFollowedByQuestionMark();
        if (_isFollowedByQuestionMark && !(isLegalUseOfOptional = this.isReturnTypeButNotOfAGetter(typeRef, parent = typeRef.eContainer()))) {
            if (parent instanceof TFormalParameter) {
                return;
            }
            if (parent instanceof N4FieldDeclaration || parent instanceof TField) {
                String message = IssueCodes.getMessageForCLF_FIELD_OPTIONAL_OLD_SYNTAX();
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)typeRef);
                if (node != null) {
                    this.addIssue(message, (EObject)typeRef, node.getOffset(), node.getLength(), "CLF_FIELD_OPTIONAL_OLD_SYNTAX");
                }
            } else {
                String message_1 = IssueCodes.getMessageForEXP_OPTIONAL_INVALID_PLACE();
                ICompositeNode node_1 = NodeModelUtils.findActualNodeFor((EObject)typeRef);
                if (node_1 != null) {
                    this.addIssue(message_1, (EObject)typeRef, node_1.getOffset(), node_1.getLength(), "EXP_OPTIONAL_INVALID_PLACE");
                }
            }
        }
    }

    private boolean isReturnTypeButNotOfAGetter(TypeRef typeRef, EObject parent) {
        return parent instanceof FunctionDefinition && ((FunctionDefinition)parent).getReturnTypeRef() == typeRef && !(parent instanceof N4GetterDeclaration) || parent instanceof TFunction && ((TFunction)parent).getReturnTypeRef() == typeRef && !(parent instanceof TGetter) || parent instanceof FunctionTypeExpression && ((FunctionTypeExpression)parent).getReturnTypeRef() == typeRef;
    }

    @Check
    public void checkFieldConstFinalValidCombinations(N4FieldDeclaration n4field) {
        if (n4field.isConst() && n4field.isDeclaredStatic()) {
            String msg = IssueCodes.getMessageForCLF_FIELD_CONST_STATIC();
            this.addIssue(msg, (EObject)n4field, (EStructuralFeature)N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName(), "CLF_FIELD_CONST_STATIC", new String[0]);
        } else if (n4field.isConst() && n4field.isFinal()) {
            String msg_1 = IssueCodes.getMessageForCLF_FIELD_CONST_FINAL();
            this.addIssue(msg_1, (EObject)n4field, (EStructuralFeature)N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName(), "CLF_FIELD_CONST_FINAL", new String[0]);
        } else if (n4field.isFinal() && n4field.isDeclaredStatic()) {
            String msg_2 = IssueCodes.getMessageForCLF_FIELD_FINAL_STATIC();
            this.addIssue(msg_2, (EObject)n4field, (EStructuralFeature)N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName(), "CLF_FIELD_FINAL_STATIC", new String[0]);
        }
    }

    @Check
    public void checkFieldConstInitialization(N4FieldDeclaration n4field) {
        boolean _not;
        boolean _constantHasInitializer = this.jsVariantHelper.constantHasInitializer((EObject)n4field);
        boolean bl = _not = !_constantHasInitializer;
        if (_not) {
            return;
        }
        if (n4field.isConst() && n4field.getExpression() == null) {
            String msg = IssueCodes.getMessageForCLF_FIELD_CONST_MISSING_INIT(n4field.getName());
            this.addIssue(msg, (EObject)n4field, (EStructuralFeature)N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName(), "CLF_FIELD_CONST_MISSING_INIT", new String[0]);
        }
    }

    @Check
    public void checkFieldFinalInitialization(N4ClassifierDefinition n4classifier) {
        N4MethodDeclaration _polyfilledOrOwnCtor;
        boolean replacedByPolyfill;
        boolean _not;
        boolean _requireCheckFinalFieldIsInitialized = this.jsVariantHelper.requireCheckFinalFieldIsInitialized((EObject)n4classifier);
        boolean bl = _not = !_requireCheckFinalFieldIsInitialized;
        if (_not) {
            return;
        }
        Functions.Function1 _function = it -> it.isFinal() && it.getExpression() == null;
        Iterable<N4FieldDeclaration> finalFieldsWithoutInit = IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)n4classifier.getOwnedFields()), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)finalFieldsWithoutInit);
        if (_isEmpty) {
            return;
        }
        boolean _isEmpty_1 = IterableExtensions.isEmpty(finalFieldsWithoutInit = this.filterFieldsInitializedViaSpecConstructor(n4classifier, finalFieldsWithoutInit));
        if (_isEmpty_1) {
            return;
        }
        boolean _isEmpty_2 = IterableExtensions.isEmpty(finalFieldsWithoutInit = this.filterFieldsInitializedExplicitlyInConstructor(n4classifier, finalFieldsWithoutInit));
        if (_isEmpty_2) {
            return;
        }
        N4MethodDeclaration _ownedCtor = n4classifier.getOwnedCtor();
        boolean bl2 = replacedByPolyfill = _ownedCtor != (_polyfilledOrOwnCtor = this.polyfilledOrOwnCtor(n4classifier));
        if (replacedByPolyfill) {
            Consumer<N4FieldDeclaration> _function_1 = it -> {
                String msg = IssueCodes.getMessageForCLF_FIELD_FINAL_MISSING_INIT_IN_STATIC_POLYFILL(it.getName());
                this.addIssue(msg, (EObject)it, (EStructuralFeature)N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName(), "CLF_FIELD_FINAL_MISSING_INIT_IN_STATIC_POLYFILL", new String[0]);
            };
            finalFieldsWithoutInit.forEach(_function_1);
        } else {
            Consumer<N4FieldDeclaration> _function_2 = it -> {
                String msg = IssueCodes.getMessageForCLF_FIELD_FINAL_MISSING_INIT(it.getName());
                this.addIssue(msg, (EObject)it, (EStructuralFeature)N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName(), "CLF_FIELD_FINAL_MISSING_INIT", new String[0]);
            };
            finalFieldsWithoutInit.forEach(_function_2);
        }
    }

    private Iterable<N4FieldDeclaration> filterFieldsInitializedViaSpecConstructor(N4ClassifierDefinition n4classifier, Iterable<N4FieldDeclaration> finalFieldsWithoutInit) {
        TypeRef typeRef;
        boolean _tripleEquals;
        Type _definedType = n4classifier.getDefinedType();
        boolean bl = _tripleEquals = _definedType == null;
        if (_tripleEquals) {
            return CollectionLiterals.emptyList();
        }
        N4MethodDeclaration ctor = this.polyfilledOrOwnCtor(n4classifier);
        TMethod _xifexpression = null;
        if (ctor == null) {
            Type _definedType_1 = n4classifier.getDefinedType();
            _xifexpression = this.containerTypesHelper.fromContext((EObject)n4classifier).findConstructor((ContainerType)_definedType_1);
        } else {
            TMember _definedTypeElement = ctor.getDefinedTypeElement();
            _xifexpression = (TMethod)_definedTypeElement;
        }
        TMethod tctor = _xifexpression;
        EList _fpars = null;
        if (tctor != null) {
            _fpars = tctor.getFpars();
        }
        TFormalParameter _findFirst = null;
        if (_fpars != null) {
            Functions.Function1 _function = it -> AnnotationDefinition.SPEC.hasAnnotation((TAnnotableElement)it);
            _findFirst = (TFormalParameter)IterableExtensions.findFirst((Iterable)_fpars, (Functions.Function1)_function);
        }
        TFormalParameter specPar = _findFirst;
        TypeRef _typeRef = null;
        if (specPar != null) {
            _typeRef = specPar.getTypeRef();
        }
        if ((typeRef = _typeRef) instanceof ThisTypeRefStructural) {
            BoundThisTypeRef boundThisTypeRef = TypeUtils.createBoundThisTypeRefStructural((ParameterizedTypeRef)TypeUtils.createTypeRef((Type)n4classifier.getDefinedType(), (TypeArgument[])new TypeArgument[0]), (ThisTypeRefStructural)((ThisTypeRefStructural)typeRef));
            Functions.Function1 _function_1 = it -> it.getName();
            Set specMemberFieldName = IterableExtensions.toSet((Iterable)IterableExtensions.map(this.structuralTypesHelper.collectStructuralMembers(RuleEnvironmentExtensions.newRuleEnvironment((EObject)n4classifier), (TypeRef)boundThisTypeRef, TypingStrategy.STRUCTURAL_FIELDS), (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = it -> {
                boolean _contains = specMemberFieldName.contains(it.getName());
                return !_contains;
            };
            return IterableExtensions.filter(finalFieldsWithoutInit, (Functions.Function1)_function_2);
        }
        return finalFieldsWithoutInit;
    }

    private Iterable<N4FieldDeclaration> filterFieldsInitializedExplicitlyInConstructor(N4ClassifierDefinition n4classifier, Iterable<N4FieldDeclaration> finalFieldsWithoutInit) {
        boolean _tripleEquals;
        N4MethodDeclaration ctor = this.polyfilledOrOwnCtor(n4classifier);
        Collection<Object> _xifexpression = null;
        Block _body = null;
        if (ctor != null) {
            _body = ctor.getBody();
        }
        boolean bl = _tripleEquals = _body == null;
        if (_tripleEquals) {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        } else {
            Functions.Function1 _function = it -> IteratorExtensions.toIterable((Iterator)it.eAllContents());
            Functions.Function1 _function_1 = it -> this.isAssignmentToFinalFieldInThis((EObject)it);
            _xifexpression = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)IteratorExtensions.toIterable((Iterator)IteratorExtensions.map((Iterator)ctor.getBody().getAllStatements(), (Functions.Function1)_function))), (Functions.Function1)_function_1)));
        }
        List finalFieldsAssignedInCtor = _xifexpression;
        Functions.Function1 _function_2 = it -> {
            boolean _contains = finalFieldsAssignedInCtor.contains(it.getDefinedField());
            return !_contains;
        };
        return IterableExtensions.filter(finalFieldsWithoutInit, (Functions.Function1)_function_2);
    }

    private TField isAssignmentToFinalFieldInThis(EObject astNode) {
        boolean _isFinal;
        IdentifiableElement prop;
        Expression _target;
        Expression lhs;
        if (astNode instanceof AssignmentExpression && (lhs = ((AssignmentExpression)astNode).getLhs()) instanceof ParameterizedPropertyAccessExpression && (_target = ((ParameterizedPropertyAccessExpression)lhs).getTarget()) instanceof ThisLiteral && (prop = ((ParameterizedPropertyAccessExpression)lhs).getProperty()) instanceof TField && (_isFinal = ((TField)prop).isFinal())) {
            return (TField)prop;
        }
        return null;
    }

    private N4MethodDeclaration polyfilledOrOwnCtor(N4ClassifierDefinition n4classifier) {
        N4MethodDeclaration _ownedCtor_1;
        boolean polyAware = n4classifier.getDefinedType().getContainingModule().isStaticPolyfillAware();
        N4ClassDeclaration _xifexpression = null;
        _xifexpression = polyAware ? this.staticPolyfillHelper.getStaticPolyfill(n4classifier.getDefinedType()) : null;
        N4ClassDeclaration polyfill = _xifexpression;
        N4MethodDeclaration _ownedCtor = null;
        if (polyfill != null) {
            _ownedCtor = polyfill.getOwnedCtor();
        }
        N4MethodDeclaration polyfillCtor = _ownedCtor;
        N4MethodDeclaration _elvis = null;
        _elvis = polyfillCtor != null ? polyfillCtor : (_ownedCtor_1 = n4classifier.getOwnedCtor());
        N4MethodDeclaration ctor = _elvis;
        return ctor;
    }
}

