/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AbstractAnnotationList;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.AnnotableExpression;
import org.eclipse.n4js.n4JS.AnnotableN4MemberDeclaration;
import org.eclipse.n4js.n4JS.AnnotablePropertyAssignment;
import org.eclipse.n4js.n4JS.AnnotableScriptElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationArgument;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.PromisifyHelper;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSAnnotationValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private IQualifiedNameProvider qnProvider;
    @Inject
    private ResourceDescriptionsProvider indexAccess;
    @Inject
    private PromisifyHelper promisifyHelper;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkAnnotations(AnnotableElement annotableElement) {
        boolean _not;
        boolean _allowAnnotation = this.jsVariantHelper.allowAnnotation((EObject)annotableElement);
        boolean bl = _not = !_allowAnnotation;
        if (_not) {
            boolean _greaterThan;
            int _size = annotableElement.getAnnotations().size();
            boolean bl2 = _greaterThan = _size > 0;
            if (_greaterThan) {
                this.addIssue(IssueCodes.getMessageForANN__ONLY_IN_N4JS(), (EObject)annotableElement, this.annoFeature(annotableElement), "ANN__ONLY_IN_N4JS", new String[0]);
            }
            return;
        }
        if (annotableElement instanceof AbstractAnnotationList) {
            return;
        }
        HashSet<String> foundNames = new HashSet<String>();
        EList _annotations = annotableElement.getAnnotations();
        for (Annotation a : _annotations) {
            boolean _not_1;
            boolean _tripleNotEquals;
            String _name = a.getName();
            boolean bl3 = _tripleNotEquals = _name != null;
            if (!_tripleNotEquals) continue;
            AnnotationDefinition def = AnnotationDefinition.find(a.getName());
            if (def == null) {
                this.addIssue(IssueCodes.getMessageForANN_NOT_DEFINED(a.getName()), (EObject)a, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_NOT_DEFINED", new String[0]);
                continue;
            }
            if (def.repeatable) {
                boolean _add = foundNames.add(a.getName());
                if (!_add) continue;
                Functions.Function1 _function = e -> {
                    String _name_1 = e.getName();
                    String _name_2 = a.getName();
                    return Objects.equal((Object)_name_1, (Object)_name_2);
                };
                this.internalCheckRepeatableAnnotations(def, IterableExtensions.filter((Iterable)annotableElement.getAnnotations(), (Functions.Function1)_function));
                continue;
            }
            boolean _add_1 = foundNames.add(a.getName());
            boolean bl4 = _not_1 = !_add_1;
            if (_not_1) {
                this.addIssue(IssueCodes.getMessageForANN_NON_REPEATABLE(a.getName()), (EObject)a, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_NON_REPEATABLE", new String[0]);
                continue;
            }
            this.internalCheckAnnotation(def, a);
        }
    }

    private void internalCheckRepeatableAnnotations(AnnotationDefinition definition, Iterable<Annotation> annotations) {
        if (IterableExtensions.forall(annotations, it -> this.holdsTargets(definition, (Annotation)it)) && IterableExtensions.forall(annotations, it -> this.holdsArgumentTypes(definition, (Annotation)it)) && definition.transitive && !definition.repeatable) {
            Consumer<Annotation> _function = it -> this.checkUnnecessaryAnnotation(definition, (Annotation)it);
            annotations.forEach(_function);
        }
    }

    private void internalCheckAnnotation(AnnotationDefinition definition, Annotation annotation) {
        if (this.holdsJavaScriptVariants(definition, annotation) && this.holdsTargets(definition, annotation) && this.holdsArgumentTypes(definition, annotation)) {
            this.checkUnnecessaryAnnotation(definition, annotation);
            String _name = annotation.getName();
            boolean _matched = false;
            if (Objects.equal((Object)_name, (Object)AnnotationDefinition.THIS.name)) {
                _matched = true;
                this.internalCheckThis(annotation);
            }
            if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.PROVIDED_BY_RUNTIME.name)) {
                _matched = true;
                this.internalCheckProvidedByRuntime(annotation);
            }
            if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.IGNORE_IMPLEMENTATION.name)) {
                _matched = true;
                this.internalCheckIgnoreImplementation(annotation);
            }
            if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.STATIC_POLYFILL_MODULE.name)) {
                _matched = true;
                this.internalCheckStaticPolyfillModule(annotation);
            }
            if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.STATIC_POLYFILL.name)) {
                _matched = true;
                this.internalCheckStaticPolyfill(annotation);
            }
            if (!_matched && Objects.equal((Object)_name, (Object)AnnotationDefinition.N4JS.name)) {
                _matched = true;
                this.internalCheckN4JS(annotation);
            }
        }
    }

    private void checkUnnecessaryAnnotation(AnnotationDefinition definition, Annotation annotation) {
        boolean _hasAnnotation;
        if (definition.transitive && !definition.repeatable && (_hasAnnotation = definition.hasAnnotation((AnnotableElement)EcoreUtil2.getContainerOfType((EObject)annotation.getAnnotatedElement().eContainer(), AnnotableElement.class)))) {
            this.addIssue(IssueCodes.getMessageForANN_UNNECESSARY(annotation.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_UNNECESSARY", new String[0]);
        }
    }

    private boolean holdsArgumentTypes(AnnotationDefinition definition, Annotation annotation) {
        int actualSize = annotation.getArgs().size();
        int expectedSize = definition.argtypes.length;
        boolean variadic = definition.argsVariadic;
        if (variadic) {
            if (expectedSize - actualSize >= 2) {
                this.addIssue(IssueCodes.getMessageForANN_WRONG_NUMBER_OF_ARGUMENTS(definition.name, expectedSize - 1, actualSize), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_WRONG_NUMBER_OF_ARGUMENTS", new String[0]);
                return false;
            }
            if (1 == expectedSize - actualSize || expectedSize == actualSize) {
                return this.validateArgumentTypes(definition, annotation);
            }
            boolean valid = true;
            int i = 0;
            while (i < actualSize) {
                boolean _not;
                EObject arg = ((AnnotationArgument)annotation.getArgs().get(i)).value();
                EClass _xifexpression = null;
                int _length = definition.argtypes.length;
                boolean _greaterThan = i + 1 > _length;
                _xifexpression = _greaterThan ? (EClass)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)definition.argtypes))) : definition.argtypes[i];
                EClass argType = _xifexpression;
                boolean _isInstance = argType.isInstance((Object)arg);
                boolean bl = _not = !_isInstance;
                if (_not) {
                    this.addIssue(IssueCodes.getMessageForANN_WRONG_ARGUMENT_TYPE(definition.name, argType.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__ARGS, i, "ANN_WRONG_ARGUMENT_TYPE", new String[0]);
                    valid = false;
                }
                ++i;
            }
            return valid;
        }
        if (actualSize > expectedSize || !definition.argsOptional && actualSize != expectedSize) {
            this.addIssue(IssueCodes.getMessageForANN_WRONG_NUMBER_OF_ARGUMENTS(definition.name, expectedSize, actualSize), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_WRONG_NUMBER_OF_ARGUMENTS", new String[0]);
            return false;
        }
        return this.validateArgumentTypes(definition, annotation);
    }

    private boolean validateArgumentTypes(AnnotationDefinition definition, Annotation annotation) {
        int actualSize = annotation.getArgs().size();
        int expectedSize = definition.argtypes.length;
        boolean valid = true;
        int min = Math.min(expectedSize, actualSize);
        int i = 0;
        while (i < min) {
            boolean _not;
            EClass argType = definition.argtypes[i];
            EObject arg = ((AnnotationArgument)annotation.getArgs().get(i)).value();
            boolean _isInstance = argType.isInstance((Object)arg);
            boolean bl = _not = !_isInstance;
            if (_not) {
                this.addIssue(IssueCodes.getMessageForANN_WRONG_ARGUMENT_TYPE(definition.name, argType.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__ARGS, i, "ANN_WRONG_ARGUMENT_TYPE", new String[0]);
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    private boolean holdsJavaScriptVariants(AnnotationDefinition definition, Annotation annotation) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)definition.javaScriptVariants)));
        if (_isNullOrEmpty) {
            return true;
        }
        EObject element = annotation.getAnnotatedElement();
        boolean _contains = ((List)Conversions.doWrapArray((Object)definition.javaScriptVariants)).contains(this.jsVariantHelper.variantMode(element));
        boolean bl = _not = !_contains;
        if (_not) {
            Functions.Function1 _function = v -> this.jsVariantHelper.getVariantName((String)v);
            String message = IssueCodes.getMessageForANN_ONL_ALLOWED_IN_VARIANTS(definition.name, this.validatorMessageHelper.orList(ListExtensions.map((List)((List)Conversions.doWrapArray((Object)definition.javaScriptVariants)), (Functions.Function1)_function)));
            this.addIssue(message, (EObject)annotation, "ANN_ONL_ALLOWED_IN_VARIANTS");
            return false;
        }
        return true;
    }

    private boolean holdsTargets(AnnotationDefinition definition, Annotation annotation) {
        boolean isElementAmongValidTargets;
        if (definition.targets == null || ((List)Conversions.doWrapArray((Object)definition.targets)).size() == 0) {
            return true;
        }
        EObject element = annotation.getAnnotatedElement();
        if (element == null) {
            return true;
        }
        boolean bl = isElementAmongValidTargets = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)definition.targets)), it -> it.isInstance((Object)element)) || IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)definition.targetsWithCustomError)), it -> it.isInstance((Object)element));
        if (!isElementAmongValidTargets) {
            boolean isExportedElementAmongValidTargets;
            ExportableElement _xifexpression = null;
            _xifexpression = element instanceof ExportDeclaration ? ((ExportDeclaration)element).getExportedElement() : null;
            ExportableElement exportedElement = _xifexpression;
            boolean bl2 = isExportedElementAmongValidTargets = exportedElement != null && (IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)definition.targets)), it -> it.isInstance((Object)exportedElement)) || IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)definition.targetsWithCustomError)), it -> it.isInstance((Object)exportedElement)));
            if (!isExportedElementAmongValidTargets) {
                this.addWrongLocationIssue(annotation);
                return false;
            }
        }
        String _name = annotation.getName();
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)AnnotationDefinition.SPEC.name)) {
            _matched = true;
            return this.internalCheckLocationSpec(annotation);
        }
        return true;
    }

    private void addWrongLocationIssue(Annotation annotation) {
        this.addIssue(IssueCodes.getMessageForANN_DISALLOWED_AT_LOCATION(annotation.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_DISALLOWED_AT_LOCATION", new String[0]);
    }

    private EStructuralFeature annoFeature(AnnotableElement element) {
        EReference _switchResult = null;
        boolean _matched = false;
        if (element instanceof AnnotableExpression) {
            _matched = true;
            _switchResult = N4JSPackage.Literals.ANNOTABLE_EXPRESSION__ANNOTATION_LIST;
        }
        if (!_matched && element instanceof AnnotableScriptElement) {
            _matched = true;
            _switchResult = N4JSPackage.Literals.ANNOTABLE_SCRIPT_ELEMENT__ANNOTATION_LIST;
        }
        if (!_matched && element instanceof AnnotableN4MemberDeclaration) {
            _matched = true;
            _switchResult = N4JSPackage.Literals.ANNOTABLE_N4_MEMBER_DECLARATION__ANNOTATION_LIST;
        }
        if (!_matched && element instanceof AnnotablePropertyAssignment) {
            _matched = true;
            _switchResult = N4JSPackage.Literals.ANNOTABLE_PROPERTY_ASSIGNMENT__ANNOTATION_LIST;
        }
        if (!_matched && element instanceof FormalParameter) {
            _matched = true;
            _switchResult = N4JSPackage.Literals.FORMAL_PARAMETER__ANNOTATIONS;
        }
        if (!_matched && element instanceof Script) {
            _matched = true;
            _switchResult = N4JSPackage.Literals.SCRIPT__ANNOTATIONS;
        }
        if (!_matched && element instanceof VariableDeclaration) {
            _matched = true;
            _switchResult = N4JSPackage.Literals.VARIABLE_DECLARATION__ANNOTATIONS;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    private void internalCheckThis(Annotation annotation) {
        EObject element = annotation.getAnnotatedElement();
        if (element == null) {
            return;
        }
        if (element instanceof N4MemberDeclaration) {
            boolean _not;
            TMember tMember = ((N4MemberDeclaration)element).getDefinedTypeElement();
            ContainerType _containingType = null;
            if (tMember != null) {
                _containingType = tMember.getContainingType();
            }
            ContainerType containingType = _containingType;
            if (tMember == null || containingType == null) {
                return;
            }
            if (tMember.isStatic() && containingType instanceof TInterface) {
                String msg = IssueCodes.getMessageForANN_THIS_DISALLOWED_ON_STATIC_MEMBER_OF_INTERFACE();
                this.addIssue(msg, (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_THIS_DISALLOWED_ON_STATIC_MEMBER_OF_INTERFACE", new String[0]);
                return;
            }
            TypeRef _switchResult = null;
            boolean _matched = false;
            if (tMember instanceof TMethod) {
                _matched = true;
                _switchResult = ((TMethod)tMember).getDeclaredThisType();
            }
            if (!_matched && tMember instanceof FieldAccessor) {
                _matched = true;
                _switchResult = ((FieldAccessor)tMember).getDeclaredThisType();
            }
            TypeRef declThisTypeRef = _switchResult;
            Object _xifexpression = null;
            boolean _isStatic = tMember.isStatic();
            _xifexpression = _isStatic ? TypeUtils.createTypeTypeRef((TypeArgument)TypeUtils.createTypeRef((Type)containingType, (TypeArgument[])new TypeArgument[0]), (boolean)false) : TypeUtils.createTypeRef((Type)containingType, (TypingStrategy)TypingStrategy.DEFAULT, (boolean)true, (TypeArgument[])new TypeArgument[0]);
            TypeTypeRef containingTypeRef = _xifexpression;
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(element);
            boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)declThisTypeRef, (TypeArgument)containingTypeRef);
            boolean bl = _not = !_subtypeSucceeded;
            if (_not) {
                String msg_1 = IssueCodes.getMessageForANN_THIS_NOT_SUBTYPE_OF_CONTAINING_TYPE(this.validatorMessageHelper.description((EObject)tMember), this.validatorMessageHelper.description((EObject)containingType), containingTypeRef.getTypeRefAsString());
                this.addIssue(msg_1, (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__ARGS, "ANN_THIS_NOT_SUBTYPE_OF_CONTAINING_TYPE", new String[0]);
            }
        }
    }

    private void internalCheckN4JS(Annotation annotation) {
        boolean _not;
        EObject element = annotation.getAnnotatedElement();
        if (element == null) {
            return;
        }
        boolean _isExternalMode = this.jsVariantHelper.isExternalMode(element);
        boolean bl = _not = !_isExternalMode;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForANN_DISALLOWED_IN_NONDEFINTION_FILE(annotation.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_DISALLOWED_IN_NONDEFINTION_FILE", new String[0]);
            return;
        }
    }

    private boolean internalCheckLocationSpec(Annotation annotation) {
        boolean _isConstructor;
        EObject parent;
        EObject element = annotation.getAnnotatedElement();
        if (element != null && (parent = element.eContainer()) instanceof N4MethodDeclaration && (_isConstructor = ((N4MethodDeclaration)parent).isConstructor())) {
            return true;
        }
        String msg = IssueCodes.getMessageForANN_ONLY_ALLOWED_LOCATION_CONSTRUCTORS(annotation.getName());
        this.addIssue(msg, (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_ONLY_ALLOWED_LOCATION_CONSTRUCTORS", new String[0]);
        return false;
    }

    private void internalCheckProvidedByRuntime(Annotation annotation) {
        boolean _not_1;
        boolean _not;
        EObject element = annotation.getAnnotatedElement();
        if (element == null) {
            return;
        }
        boolean _isExternalMode = this.jsVariantHelper.isExternalMode(element);
        boolean bl = _not = !_isExternalMode;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForANN_DISALLOWED_IN_NONDEFINTION_FILE(annotation.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_DISALLOWED_IN_NONDEFINTION_FILE", new String[0]);
            return;
        }
        URI projURI = element.eResource().getURI();
        Optional<? extends IN4JSProject> project = this.n4jsCore.findProject(projURI);
        boolean _isPresent = project.isPresent();
        boolean bl2 = _not_1 = !_isPresent;
        if (_not_1) {
            String msg = IssueCodes.getMessageForNO_PROJECT_FOUND(projURI);
            Script script = (Script)EcoreUtil2.getContainerOfType((EObject)element, Script.class);
            this.addIssue(msg, (EObject)script, "NO_PROJECT_FOUND");
        } else {
            ProjectType projectType;
            IN4JSProject _get = (IN4JSProject)project.get();
            ProjectType _projectType = null;
            if (_get != null) {
                _projectType = _get.getProjectType();
            }
            if ((projectType = _projectType) != ProjectType.RUNTIME_ENVIRONMENT && projectType != ProjectType.RUNTIME_LIBRARY) {
                this.addIssue(IssueCodes.getMessageForANN_DISALLOWED_IN_NON_RUNTIME_COMPONENT(annotation.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_DISALLOWED_IN_NON_RUNTIME_COMPONENT", new String[0]);
                return;
            }
        }
    }

    private void internalCheckIgnoreImplementation(Annotation annotation) {
        boolean _not;
        EObject element = annotation.getAnnotatedElement();
        if (element == null) {
            return;
        }
        boolean _isExternalMode = this.jsVariantHelper.isExternalMode(element);
        boolean bl = _not = !_isExternalMode;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForANN_DISALLOWED_IN_NONDEFINTION_FILE(annotation.getName()), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_DISALLOWED_IN_NONDEFINTION_FILE", new String[0]);
            return;
        }
    }

    private void internalCheckStaticPolyfillModule(Annotation annotation) {
        boolean _not_1;
        boolean _not;
        EObject element = annotation.getAnnotatedElement();
        if (element == null) {
            return;
        }
        if (!(element instanceof Script)) {
            return;
        }
        Script script = (Script)element;
        boolean _isContainedInStaticPolyfillAware = N4JSLanguageUtils.isContainedInStaticPolyfillAware((AnnotableElement)script);
        if (_isContainedInStaticPolyfillAware) {
            this.addIssue(IssueCodes.getMessageForANN_POLY_AWARE_AND_MODULE_MUTUAL_EXCLUSIVE(), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_POLY_AWARE_AND_MODULE_MUTUAL_EXCLUSIVE", new String[0]);
            return;
        }
        QualifiedName moduleQN = this.qnProvider.getFullyQualifiedName((EObject)script.getModule());
        boolean _isModulePolyfill = N4TSQualifiedNameProvider.isModulePolyfill((QualifiedName)moduleQN);
        boolean bl = _not = !_isModulePolyfill;
        if (_not) {
            TModule _module = null;
            if (script != null) {
                _module = script.getModule();
            }
            Resource _eResource = null;
            if (_module != null) {
                _eResource = _module.eResource();
            }
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            String _plus = "### strange should start with '!MPOLY' for " + _uRI;
            InputOutput.println((Object)_plus);
            return;
        }
        if (moduleQN == null) {
            return;
        }
        IN4JSProject currentProject = (IN4JSProject)this.n4jsCore.findProject(script.eResource().getURI()).orNull();
        if (currentProject == null) {
            return;
        }
        IResourceDescriptions index = this.indexAccess.getResourceDescriptions(script.eResource().getResourceSet());
        IResourceDescription currentResDesc = index.getResourceDescription(script.eResource().getURI());
        Functions.Function1 _function = it -> it.getQualifiedName() != null && it.getQualifiedName().startsWith(moduleQN);
        Functions.Function1 _function_1 = it -> it.getEObjectURI();
        Functions.Function1 _function_2 = it -> it.trimFragment();
        Functions.Function1 _function_3 = it -> index.getResourceDescription(it);
        Functions.Function1 _function_4 = it -> !Objects.equal((Object)currentResDesc, (Object)it);
        Functions.Function1 _function_5 = it -> {
            boolean _xblockexpression = false;
            IN4JSProject prj = (IN4JSProject)this.n4jsCore.findProject(it.getURI()).orNull();
            _xblockexpression = Objects.equal((Object)currentProject, (Object)prj);
            return _xblockexpression;
        };
        List sameResdesc = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)index.getExportedObjectsByType(TypesPackage.Literals.TMODULE), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        boolean _isEmpty = sameResdesc.isEmpty();
        boolean bl2 = _not_1 = !_isEmpty;
        if (_not_1) {
            String _xifexpression = null;
            int _size = sameResdesc.size();
            boolean _greaterThan = _size > 1;
            _xifexpression = _greaterThan ? "s" : "";
            String _plus_1 = "module" + _xifexpression;
            String msg_prefix = String.valueOf(_plus_1) + " in ";
            Functions.Function1 _function_6 = it -> {
                String _xblockexpression = null;
                Optional<? extends IN4JSSourceContainer> srcCon = this.n4jsCore.findN4JSSourceContainer(it.getURI());
                String _xifexpression_1 = null;
                boolean _isPresent = srcCon.isPresent();
                _xifexpression_1 = _isPresent ? ((IN4JSSourceContainer)srcCon.get()).getRelativeLocation() : it.getURI().toString();
                _xblockexpression = _xifexpression_1;
                return _xblockexpression;
            };
            String clashes = Joiner.on((String)", ").join((Iterable)ListExtensions.map((List)sameResdesc, (Functions.Function1)_function_6));
            this.addIssue(IssueCodes.getMessageForPOLY_CLASH_IN_STATIC_POLYFILL_MODULE(String.valueOf(msg_prefix) + clashes), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "POLY_CLASH_IN_STATIC_POLYFILL_MODULE", new String[0]);
        }
    }

    private void internalCheckStaticPolyfill(Annotation annotation) {
        boolean _not;
        EObject _annotatedElement = annotation.getAnnotatedElement();
        AnnotableElement element = (AnnotableElement)_annotatedElement;
        if (element == null) {
            return;
        }
        boolean _isContainedInStaticPolyfillModule = N4JSLanguageUtils.isContainedInStaticPolyfillModule(element);
        boolean bl = _not = !_isContainedInStaticPolyfillModule;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForANN_POLY_STATIC_POLY_ONLY_IN_POLYFILL_MODULE(), (EObject)annotation, (EStructuralFeature)N4JSPackage.Literals.ANNOTATION__NAME, "ANN_POLY_STATIC_POLY_ONLY_IN_POLYFILL_MODULE", new String[0]);
            return;
        }
        AnnotableElement annoTarget = element;
        if (element instanceof ExportDeclaration) {
            annoTarget = ((ExportDeclaration)element).getExportedElement();
        }
        boolean cfr_ignored_0 = annoTarget instanceof N4ClassDeclaration;
    }

    @Check
    public boolean checkPromisifiableMethod(FunctionDeclaration methodDecl) {
        boolean _xifexpression = false;
        boolean _hasAnnotation = AnnotationDefinition.PROMISIFIABLE.hasAnnotation((AnnotableElement)methodDecl);
        if (_hasAnnotation) {
            _xifexpression = this.holdsPromisifiablePreconditions((FunctionDefinition)methodDecl);
        }
        return _xifexpression;
    }

    @Check
    public boolean checkPromisifiableMethod(N4MethodDeclaration methodDecl) {
        boolean _xifexpression = false;
        boolean _hasAnnotation = AnnotationDefinition.PROMISIFIABLE.hasAnnotation((AnnotableElement)methodDecl);
        if (_hasAnnotation) {
            _xifexpression = this.holdsPromisifiablePreconditions((FunctionDefinition)methodDecl);
        }
        return _xifexpression;
    }

    private boolean holdsPromisifiablePreconditions(FunctionDefinition funDef) {
        boolean _switchResult = false;
        PromisifyHelper.CheckResult _checkPromisifiablePreconditions = this.promisifyHelper.checkPromisifiablePreconditions(funDef);
        if (_checkPromisifiablePreconditions != null) {
            switch (_checkPromisifiablePreconditions) {
                case MISSING_CALLBACK: {
                    boolean _xblockexpression = false;
                    this.addIssue(IssueCodes.getMessageForANN_PROMISIFIABLE_MISSING_CALLBACK(), (EObject)AnnotationDefinition.PROMISIFIABLE.getAnnotation((AnnotableElement)funDef), "ANN_PROMISIFIABLE_MISSING_CALLBACK");
                    _switchResult = _xblockexpression = false;
                    break;
                }
                case BAD_CALLBACK__MORE_THAN_ONE_ERROR: {
                    boolean _xblockexpression_1 = false;
                    this.addIssue(IssueCodes.getMessageForANN_PROMISIFIABLE_BAD_CALLBACK_MORE_THAN_ONE_ERROR(), (EObject)AnnotationDefinition.PROMISIFIABLE.getAnnotation((AnnotableElement)funDef), "ANN_PROMISIFIABLE_BAD_CALLBACK_MORE_THAN_ONE_ERROR");
                    _switchResult = _xblockexpression_1 = false;
                    break;
                }
                case BAD_CALLBACK__ERROR_NOT_FIRST_ARG: {
                    boolean _xblockexpression_2 = false;
                    this.addIssue(IssueCodes.getMessageForANN_PROMISIFIABLE_BAD_CALLBACK_ERROR_NOT_FIRST_ARG(), (EObject)AnnotationDefinition.PROMISIFIABLE.getAnnotation((AnnotableElement)funDef), "ANN_PROMISIFIABLE_BAD_CALLBACK_ERROR_NOT_FIRST_ARG");
                    _switchResult = _xblockexpression_2 = false;
                    break;
                }
                case OK: {
                    _switchResult = true;
                    break;
                }
            }
        }
        return _switchResult;
    }
}

