/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.formatting2;

import org.eclipse.n4js.formatting2.InsertSemiBase;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class InsertSemi implements InsertSemiBase {
  private final ITextSegment region;
  
  private final String text;
  
  @Override
  public ITextReplacerContext createReplacements(final ITextReplacerContext context) {
    context.addReplacement(this.region.replaceWith(this.text));
    return context;
  }
  
  public InsertSemi(final ITextSegment region, final String text) {
    super();
    this.region = region;
    this.text = text;
  }
  
  @Pure
  public ITextSegment getRegion() {
    return this.region;
  }
  
  @Pure
  public String getText() {
    return this.text;
  }
}
