/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.formatting2;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.formatting2.InsertSemi;
import org.eclipse.n4js.formatting2.N4JSFormatterPreferenceKeys;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionExtensions;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class N4JSGenericFormatter {
  @Extension
  private final N4JSGrammarAccess _n4JSGrammarAccess;
  
  @Extension
  private final ITextRegionExtensions _iTextRegionExtensions;
  
  public final static int PRIO_1 = (-10);
  
  public final static int PRIO_2 = (-9);
  
  public final static int PRIO_3 = (-8);
  
  public void formatColon(final EObject semanticElement, @Extension final IFormattableDocument document) {
    List<ISemanticRegion> _keywords = this._iTextRegionExtensions.allRegionsFor(semanticElement).keywords(":");
    for (final ISemanticRegion colon : _keywords) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
        it.setPriority(N4JSGenericFormatter.PRIO_3);
      };
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
        it.setPriority(N4JSGenericFormatter.PRIO_2);
      };
      document.append(document.prepend(colon, _function), _function_1);
    }
  }
  
  /**
   * Formats whitespace around already present semicolons (;) and inserts new semicolons where the parser expects them.
   */
  public void formatSemicolons(final EObject script, @Extension final IFormattableDocument document) {
    List<ISemanticRegion> _ruleCallsTo = this._iTextRegionExtensions.allRegionsFor(script).ruleCallsTo(this._n4JSGrammarAccess.getSemiRule());
    for (final ISemanticRegion region : _ruleCallsTo) {
      {
        final String text = region.getText();
        final IHiddenRegion previous = region.getPreviousHiddenRegion();
        boolean _equals = Objects.equal(text, ";");
        if (_equals) {
          final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
            it.noSpace();
            it.setNewLines(0);
            it.highPriority();
          };
          document.prepend(region, _function);
        } else {
          boolean _and = false;
          ISemanticRegion _nextSemanticRegion = region.getNextSemanticRegion();
          String _text = null;
          if (_nextSemanticRegion!=null) {
            _text=_nextSemanticRegion.getText();
          }
          boolean _equals_1 = Objects.equal(_text, "}");
          if (!_equals_1) {
            _and = false;
          } else {
            boolean _isMultiline = region.isMultiline();
            boolean _not = (!_isMultiline);
            _and = _not;
          }
          if (_and) {
          } else {
            boolean _containsComment = previous.containsComment();
            if (_containsComment) {
              final ITextSegment insertAt = region.getTextRegionAccess().regionForOffset(previous.getOffset(), 0);
              InsertSemi _insertSemi = new InsertSemi(insertAt, ";");
              document.addReplacer(_insertSemi);
            } else {
              boolean _isEmpty = text.trim().isEmpty();
              if (_isEmpty) {
                final int lbIdx = text.indexOf("\n");
                if ((lbIdx >= 0)) {
                  final ITextSegment replaceRegion = region.getTextRegionAccess().regionForOffset(region.getOffset(), (lbIdx + 1));
                  InsertSemi _insertSemi_1 = new InsertSemi(replaceRegion, ";\n");
                  document.addReplacer(_insertSemi_1);
                } else {
                  InsertSemi _insertSemi_2 = new InsertSemi(region, ";");
                  document.addReplacer(_insertSemi_2);
                }
              } else {
                final ITextSegment insertAt_1 = region.getTextRegionAccess().regionForOffset(region.getOffset(), 0);
                InsertSemi _insertSemi_3 = new InsertSemi(insertAt_1, ";");
                document.addReplacer(_insertSemi_3);
              }
            }
          }
        }
      }
    }
  }
  
  /**
   * Format whitespace around (), [], and {}
   * 
   * When multiple pairs of (), [], or {} open in the same line, indentation is only applied for the innermost pair.
   */
  public void formatParenthesisBracketsAndBraces(final EObject script, @Extension final IFormattableDocument document) {
    final ArrayList<Pair<ISemanticRegion, ISemanticRegion>> all = CollectionLiterals.<Pair<ISemanticRegion, ISemanticRegion>>newArrayList();
    List<Pair<ISemanticRegion, ISemanticRegion>> _keywordPairs = this._iTextRegionExtensions.allRegionsFor(script).keywordPairs("(", ")");
    Iterables.<Pair<ISemanticRegion, ISemanticRegion>>addAll(all, _keywordPairs);
    List<Pair<ISemanticRegion, ISemanticRegion>> _keywordPairs_1 = this._iTextRegionExtensions.allRegionsFor(script).keywordPairs("{", "}");
    Iterables.<Pair<ISemanticRegion, ISemanticRegion>>addAll(all, _keywordPairs_1);
    List<Pair<ISemanticRegion, ISemanticRegion>> _keywordPairs_2 = this._iTextRegionExtensions.allRegionsFor(script).keywordPairs("[", "]");
    Iterables.<Pair<ISemanticRegion, ISemanticRegion>>addAll(all, _keywordPairs_2);
    final Function1<Pair<ISemanticRegion, ISemanticRegion>, Integer> _function = (Pair<ISemanticRegion, ISemanticRegion> it) -> {
      return Integer.valueOf(IterableExtensions.<ILineRegion>head(it.getKey().getLineRegions()).getOffset());
    };
    final Map<Integer, List<Pair<ISemanticRegion, ISemanticRegion>>> byLine = IterableExtensions.<Integer, Pair<ISemanticRegion, ISemanticRegion>>groupBy(all, _function);
    Set<Map.Entry<Integer, List<Pair<ISemanticRegion, ISemanticRegion>>>> _entrySet = byLine.entrySet();
    for (final Map.Entry<Integer, List<Pair<ISemanticRegion, ISemanticRegion>>> e : _entrySet) {
      {
        final Function1<Pair<ISemanticRegion, ISemanticRegion>, Integer> _function_1 = (Pair<ISemanticRegion, ISemanticRegion> it) -> {
          return Integer.valueOf(it.getKey().getOffset());
        };
        final List<Pair<ISemanticRegion, ISemanticRegion>> bracePairsInSameLine = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>, Integer>sortBy(e.getValue(), _function_1);
        final Pair<ISemanticRegion, ISemanticRegion> outermost = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(bracePairsInSameLine);
        final Pair<ISemanticRegion, ISemanticRegion> innermost = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>last(bracePairsInSameLine);
        IHiddenRegion lastOpen = null;
        IHiddenRegion lastClose = null;
        for (final Pair<ISemanticRegion, ISemanticRegion> pair : bracePairsInSameLine) {
          {
            final ISemanticRegion open = pair.getKey();
            final ISemanticRegion close = pair.getValue();
            if (((!Objects.equal(open.getPreviousHiddenRegion(), lastOpen)) && (lastOpen != null))) {
              final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
                it.noSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              document.prepend(open, _function_2);
            }
            if ((pair != innermost)) {
              final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
                it.noSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              document.append(open, _function_3);
              final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
                it.noSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              document.prepend(close, _function_4);
            }
            IHiddenRegion _nextHiddenRegion = close.getNextHiddenRegion();
            boolean _notEquals = (!Objects.equal(_nextHiddenRegion, lastClose));
            if (_notEquals) {
              if ((pair == outermost)) {
              } else {
                final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
                  it.noSpace();
                  it.setPriority(N4JSGenericFormatter.PRIO_1);
                };
                document.append(close, _function_5);
              }
            }
            lastOpen = open.getNextHiddenRegion();
            lastClose = close.getPreviousHiddenRegion();
          }
        }
        final ISemanticRegion open = innermost.getKey();
        final ISemanticRegion close = innermost.getValue();
        if ((Objects.equal(open.getNextSemanticRegion(), close) && (!open.getNextHiddenRegion().isMultiline()))) {
          final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
            it.noSpace();
            it.setPriority(N4JSGenericFormatter.PRIO_1);
          };
          document.append(open, _function_2);
        } else {
          boolean _isMultiline = close.getPreviousHiddenRegion().isMultiline();
          if (_isMultiline) {
            final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
              it.newLine();
              it.setPriority(N4JSGenericFormatter.PRIO_1);
            };
            this.appendNewLine(document.prepend(close, _function_3), document);
            final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
              it.newLine();
              it.setPriority(N4JSGenericFormatter.PRIO_1);
            };
            document.append(open, _function_4);
            final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
              it.indent();
            };
            document.<ISemanticRegion, ISemanticRegion>interior(innermost, _function_5);
            List<ISemanticRegion> _keywords = this._iTextRegionExtensions.regionFor(open.getSemanticElement()).keywords(",");
            for (final ISemanticRegion comma : _keywords) {
              final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
                it.noSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it) -> {
                it.setNewLines(1, 1, 2);
                it.setPriority(N4JSGenericFormatter.PRIO_2);
              };
              document.append(document.prepend(comma, _function_6), _function_7);
            }
          } else {
            Boolean _preference = document.getRequest().getPreferences().<Boolean>getPreference(N4JSFormatterPreferenceKeys.FORMAT_SURROUND_PAREN_CONTENT_WITH_SPACE);
            if ((_preference).booleanValue()) {
              final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it) -> {
                it.oneSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              document.prepend(close, _function_8);
              final Procedure1<IHiddenRegionFormatter> _function_9 = (IHiddenRegionFormatter it) -> {
                it.oneSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              document.append(open, _function_9);
            }
            List<ISemanticRegion> _keywords_1 = this._iTextRegionExtensions.regionFor(open.getSemanticElement()).keywords(",");
            for (final ISemanticRegion comma_1 : _keywords_1) {
              final Procedure1<IHiddenRegionFormatter> _function_10 = (IHiddenRegionFormatter it) -> {
                it.noSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              final Procedure1<IHiddenRegionFormatter> _function_11 = (IHiddenRegionFormatter it) -> {
                it.oneSpace();
                it.setPriority(N4JSGenericFormatter.PRIO_1);
              };
              document.append(document.prepend(comma_1, _function_10), _function_11);
            }
          }
        }
      }
    }
  }
  
  public ISemanticRegion appendNewLine(final ISemanticRegion appendAfter, @Extension final IFormattableDocument doc) {
    ISemanticRegion _nextSemanticRegion = appendAfter.getNextSemanticRegion();
    EObject _grammarElement = null;
    if (_nextSemanticRegion!=null) {
      _grammarElement=_nextSemanticRegion.getGrammarElement();
    }
    final EObject semi = _grammarElement;
    boolean _and = false;
    if (!(semi instanceof RuleCall)) {
      _and = false;
    } else {
      AbstractRule _rule = null;
      if (((RuleCall) semi)!=null) {
        _rule=((RuleCall) semi).getRule();
      }
      ParserRule _semiRule = this._n4JSGrammarAccess.getSemiRule();
      boolean _equals = Objects.equal(_rule, _semiRule);
      _and = _equals;
    }
    if (_and) {
    } else {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.newLine();
        it.setPriority(N4JSGenericFormatter.PRIO_1);
      };
      doc.append(appendAfter, _function);
    }
    return appendAfter;
  }
  
  public N4JSGenericFormatter(final N4JSGrammarAccess _n4JSGrammarAccess, final ITextRegionExtensions _iTextRegionExtensions) {
    super();
    this._n4JSGrammarAccess = _n4JSGrammarAccess;
    this._iTextRegionExtensions = _iTextRegionExtensions;
  }
}
