/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.n4js.typesbuilder.VersionedTypesBuilderUtil;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class N4JSEnumDeclarationTypesBuilder {
  @Inject
  @Extension
  private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
  
  boolean relinkTEnum(final N4EnumDeclaration n4Enum, final TModule target, final boolean preLinkingPhase, final int idx) {
    String _name = n4Enum.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return false;
    }
    Type _get = target.getTopLevelTypes().get(idx);
    final TEnum enumType = ((TEnum) _get);
    this._n4JSTypesBuilderHelper.ensureEqualName(n4Enum, enumType);
    this.relinkTEnumLiterals(n4Enum, enumType, preLinkingPhase);
    enumType.setAstElement(n4Enum);
    n4Enum.setDefinedType(enumType);
    return true;
  }
  
  private int relinkTEnumLiterals(final N4EnumDeclaration n4Enum, final TEnum tEnum, final boolean preLinkingPhase) {
    final Function2<Integer, N4EnumLiteral, Integer> _function = (Integer idx, N4EnumLiteral n4EnumLit) -> {
      boolean _relinkTEnumLiteral = this.relinkTEnumLiteral(n4EnumLit, tEnum, preLinkingPhase, (idx).intValue());
      if (_relinkTEnumLiteral) {
        return Integer.valueOf(((idx).intValue() + 1));
      }
      return idx;
    };
    return (int) IterableExtensions.<N4EnumLiteral, Integer>fold(n4Enum.getLiterals(), Integer.valueOf(0), _function);
  }
  
  private boolean relinkTEnumLiteral(final N4EnumLiteral n4EnumLit, final TEnum tEnum, final boolean preLinkingPhase, final int idx) {
    final TEnumLiteral tEnumLit = tEnum.getLiterals().get(idx);
    this._n4JSTypesBuilderHelper.ensureEqualName(n4EnumLit, tEnumLit);
    tEnumLit.setAstElement(n4EnumLit);
    n4EnumLit.setDefinedLiteral(tEnumLit);
    return true;
  }
  
  protected TEnum createTEnum(final N4EnumDeclaration n4Enum, final TModule target, final boolean preLinkingPhase) {
    String _name = n4Enum.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return null;
    }
    final TEnum enumType = this.createTEnum(n4Enum);
    this._n4JSTypesBuilderHelper.<N4EnumDeclaration>setTypeAccessModifier(enumType, n4Enum);
    this._n4JSTypesBuilderHelper.setProvidedByRuntime(enumType, n4Enum, preLinkingPhase);
    this.addLiterals(enumType, n4Enum, preLinkingPhase);
    this._n4JSTypesBuilderHelper.copyAnnotations(enumType, n4Enum, preLinkingPhase);
    enumType.setAstElement(n4Enum);
    n4Enum.setDefinedType(enumType);
    EList<Type> _topLevelTypes = target.getTopLevelTypes();
    _topLevelTypes.add(enumType);
    VersionedTypesBuilderUtil.setTypeVersion(enumType, n4Enum);
    return enumType;
  }
  
  private TEnum createTEnum(final N4EnumDeclaration n4Enum) {
    TEnum _xblockexpression = null;
    {
      final TEnum enumType = TypesFactory.eINSTANCE.createTEnum();
      enumType.setName(n4Enum.getName());
      enumType.setExportedName(n4Enum.getExportedName());
      enumType.setExternal(n4Enum.isExternal());
      _xblockexpression = enumType;
    }
    return _xblockexpression;
  }
  
  private void addLiterals(final TEnum enumType, final N4EnumDeclaration n4Enum, final boolean preLinkingPhase) {
    final Function1<N4EnumLiteral, TEnumLiteral> _function = (N4EnumLiteral it) -> {
      return this.createEnumLiteral(it, preLinkingPhase);
    };
    Iterables.<TEnumLiteral>addAll(enumType.getLiterals(), IterableExtensions.<N4EnumLiteral, TEnumLiteral>map(Iterables.<N4EnumLiteral>filter(n4Enum.getLiterals(), N4EnumLiteral.class), _function));
  }
  
  private TEnumLiteral createEnumLiteral(final N4EnumLiteral it, final boolean preLinkingPhase) {
    TEnumLiteral _xblockexpression = null;
    {
      final TEnumLiteral enumLiteral = TypesFactory.eINSTANCE.createTEnumLiteral();
      enumLiteral.setName(it.getName());
      enumLiteral.setValue(it.getValue());
      enumLiteral.setAstElement(it);
      it.setDefinedLiteral(enumLiteral);
      _xblockexpression = enumLiteral;
    }
    return _xblockexpression;
  }
}
