/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tester.nodejs.ui.launch;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.n4js.tester.nodejs.ui.launch.NodejsTesterLaunchConfigurationTab;
import org.eclipse.n4js.tester.ui.TesterLaunchConfigurationMainTab;

/**
 * Node.js launch configuration tab group. Creates the main tab and one for the Node.js specific
 * settings.
 */
@SuppressWarnings("all")
public class NodejsTesterLaunchConfigurationTabGroup extends AbstractLaunchConfigurationTabGroup {
  @Inject
  private Provider<TesterLaunchConfigurationMainTab> mainTabProvider;
  
  @Inject
  private Provider<NodejsTesterLaunchConfigurationTab> nodejsTabProvider;
  
  @Override
  public void createTabs(final ILaunchConfigurationDialog dialog, final String mode) {
    TesterLaunchConfigurationMainTab _get = this.mainTabProvider.get();
    NodejsTesterLaunchConfigurationTab _get_1 = this.nodejsTabProvider.get();
    this.setTabs(new ILaunchConfigurationTab[] { _get, _get_1 });
  }
}
