/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.MockN4JSModel;
import org.eclipse.n4js.MockProject;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.internal.N4JSRuntimeCore;
import org.eclipse.n4js.projectModel.IN4JSProject;

@Singleton
public class N4JSRuntimeCoreWithMockProject
extends N4JSRuntimeCore {
    final IN4JSProject mockProject;

    @Inject
    public N4JSRuntimeCoreWithMockProject(FileBasedWorkspace workspace, MockN4JSModel model) {
        super(workspace, (N4JSModel)model);
        this.mockProject = this.createMockProject(model);
    }

    private IN4JSProject createMockProject(MockN4JSModel model) {
        MockProject project = new MockProject(MockProject.MOCK_URI, model);
        model.setMockProject(project);
        return project;
    }

    public Optional<? extends IN4JSProject> findProject(URI nestedLocation) {
        if (nestedLocation == null) {
            return Optional.absent();
        }
        IN4JSProject result = this.mockProject;
        return Optional.fromNullable((Object)result);
    }
}

