/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.csv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CSVRecord
implements Iterable<String> {
    private final List<String> record;

    protected CSVRecord() {
        this.record = new ArrayList<String>();
    }

    private CSVRecord(List<String> record) {
        this.record = Objects.requireNonNull(record);
    }

    protected void add(String field) {
        this.record.add(Objects.requireNonNull(field));
    }

    public int getSize() {
        return this.record.size();
    }

    public String get(int index) {
        return this.record.get(index);
    }

    public CSVRecord getRange(int index, int count) {
        int actualCount = count < 0 ? this.getSize() - index : count;
        return new CSVRecord(this.record.subList(index, index + actualCount));
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableList(this.record).iterator();
    }

    public String toString() {
        return this.record.toString();
    }
}

