/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.validation.suppression;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.xpect.validation.suppression.IssueCode;
import org.eclipse.n4js.xpect.validation.suppression.IssueConfiguration;
import org.eclipse.n4js.xpect.validation.suppression.SuppressIssuesSetupRoot;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectReplace;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.IRegion;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestModuleSetup;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@XpectSetupFactory
@XpectReplace(value={ValidationTestModuleSetup.IssuesByLineProvider.class})
@XpectImport(value={SuppressIssuesSetupRoot.class})
public abstract class AbstractSuppressIssuesSetup
extends ValidationTestModuleSetup.IssuesByLineProvider {
    private final Collection<String> suppressedIssueCodes = new ArrayList<String>(this.getDefaultSuppressedIssueCodes());
    private Multimap<IRegion, Issue> issuesByLine = null;

    public AbstractSuppressIssuesSetup(@ThisResource XtextResource resource, ISetupInitializer<SuppressIssuesSetupRoot> setupInitializer) {
        super(resource);
        this.initialize(setupInitializer);
    }

    private void initialize(ISetupInitializer<SuppressIssuesSetupRoot> setupInitializer) {
        boolean _tripleEquals;
        SuppressIssuesSetupRoot setup = new SuppressIssuesSetupRoot();
        setupInitializer.initialize((Object)setup);
        IssueConfiguration _issueConfiguration = setup.getIssueConfiguration();
        boolean bl = _tripleEquals = _issueConfiguration == null;
        if (_tripleEquals) {
            return;
        }
        List<IssueCode> _issueCodes = setup.getIssueConfiguration().getIssueCodes();
        for (IssueCode code : _issueCodes) {
            boolean _isEnabled = code.isEnabled();
            if (_isEnabled) {
                this.suppressedIssueCodes.remove(code.getName());
                continue;
            }
            this.suppressedIssueCodes.add(code.getName());
        }
    }

    protected abstract Collection<String> getDefaultSuppressedIssueCodes();

    protected boolean includeIssue(Issue issue) {
        boolean _xifexpression = false;
        boolean _contains = this.suppressedIssueCodes.contains(issue.getCode());
        _xifexpression = _contains ? false : super.includeIssue(issue);
        return _xifexpression;
    }

    @Creates(value=ValidationTestModuleSetup.IssuesByLine.class)
    public Multimap<IRegion, Issue> collectIssuesByLine() {
        boolean _isEmpty;
        boolean _not;
        if (this.issuesByLine == null) {
            IResourceValidator _resourceValidator = this.getResource().getResourceServiceProvider().getResourceValidator();
            ValidationTestModuleSetup.TestingResourceValidator validator = (ValidationTestModuleSetup.TestingResourceValidator)_resourceValidator;
            this.issuesByLine = validator.validateDelegateAndMapByOffset((Resource)this.getResource(), CheckMode.ALL, CancelIndicator.NullImpl, null);
        }
        boolean bl = _not = !(_isEmpty = this.suppressedIssueCodes.isEmpty());
        if (_not) {
            HashMultimap filteredResults = HashMultimap.create(this.issuesByLine);
            Functions.Function1 _function = entry -> {
                boolean _includeIssue = this.includeIssue((Issue)entry.getValue());
                return !_includeIssue;
            };
            Consumer<Map.Entry> _function_1 = entry -> filteredResults.remove(entry.getKey(), entry.getValue());
            IterableExtensions.filter((Iterable)this.issuesByLine.entries(), (Functions.Function1)_function).forEach(_function_1);
            this.issuesByLine = filteredResults;
        }
        return this.issuesByLine;
    }
}

