/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class FunctionDeclarationTransformation extends Transformation {
  @Inject
  private TypeAssistant typeAssistant;
  
  @Override
  public void assertPreConditions() {
  }
  
  @Override
  public void assertPostConditions() {
    final Function1<FunctionDeclaration, Boolean> _function = (FunctionDeclaration it) -> {
      return Boolean.valueOf(this.typeAssistant.isTopLevel(it));
    };
    this.assertFalse("there should not be any top-level FunctionDeclarations in the intermediate model", 
      IteratorExtensions.<FunctionDeclaration>exists(Iterators.<FunctionDeclaration>filter(this.getState().im.eAllContents(), FunctionDeclaration.class), _function));
  }
  
  @Override
  public void analyze() {
  }
  
  @Override
  public void transform() {
    final Consumer<FunctionDeclaration> _function = (FunctionDeclaration it) -> {
      this.doTransform(it);
    };
    this.<FunctionDeclaration>collectNodes(this.getState().im, FunctionDeclaration.class, false).forEach(_function);
  }
  
  private void doTransform(final FunctionDeclaration funDecl) {
    final String name = funDecl.getName();
    FunctionExpression __FunExpr = TranspilerBuilderBlocks._FunExpr(funDecl.isAsync(), name, 
      ((FormalParameter[])Conversions.unwrapArray(funDecl.getFpars(), FormalParameter.class)), 
      funDecl.getBody());
    final Procedure1<FunctionExpression> _function = (FunctionExpression it) -> {
      it.setGenerator(funDecl.isGenerator());
      if (((funDecl.getAnnotationList() != null) && (funDecl.getAnnotationList().getAnnotations().size() > 0))) {
        it.setAnnotationList(TranspilerBuilderBlocks._ExprAnnoList(((Annotation[])Conversions.unwrapArray(funDecl.getAnnotationList().getAnnotations(), Annotation.class))));
      }
    };
    FunctionExpression _doubleArrow = ObjectExtensions.<FunctionExpression>operator_doubleArrow(__FunExpr, _function);
    final VariableDeclaration varDecl = TranspilerBuilderBlocks._VariableDeclaration(name, _doubleArrow);
    this.replace(funDecl, varDecl);
    this.getState().info.markAsToHoist(varDecl);
  }
}
