/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.console;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.n4js.utils.NLSMessages;
import org.eclipse.n4js.utils.NLSMessagesProcessor;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

/**
 * Provides messages and helper methods for creating NLS messages. This class uses an active annotation
 * {@code @NLSMessages} to derive constants and methods out of the entries of the {@code messages.properties}. See
 * {@link NLSMessagesProcessor} for details about the message format.
 */
@NLSMessages(propertyFileName = "ConsoleMessages")
@SuppressWarnings("all")
public class ConsoleMessages {
  private final static String BUNDLE_NAME = ConsoleMessages.class.getPackage().getName() + ".ConsoleMessages";
  
  private final static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
  
  private final static String INITIALIZER = new Function0<String>() {
        public String apply() {
          org.eclipse.osgi.util.NLS.initializeMessages(BUNDLE_NAME, ConsoleMessages.class);
          return "";
        }
      }.apply();;
  
  private static String getString(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	return value;
    } catch (MissingResourceException e) {
    	return '!' + key + '!';
    }
  }
  
  public final static String ConsoleCallToAction = "ConsoleCallToAction";
  
  /**
   * Paste stack traces into this console and follow hyperlinks to source code.
   */
  public static String msgConsoleCallToAction() {
    return org.eclipse.osgi.util.NLS.bind(getString(ConsoleCallToAction), new Object [] {  });
  }
  
  public final static String HyperlinkError = "HyperlinkError";
  
  /**
   * Hyperlink Error
   */
  public static String msgHyperlinkError() {
    return org.eclipse.osgi.util.NLS.bind(getString(HyperlinkError), new Object [] {  });
  }
  
  public final static String HyperlinkInformation = "HyperlinkInformation";
  
  /**
   * Information
   */
  public static String msgHyperlinkInformation() {
    return org.eclipse.osgi.util.NLS.bind(getString(HyperlinkInformation), new Object [] {  });
  }
  
  public final static String HyperlinkSearching = "HyperlinkSearching";
  
  /**
   * Searching...
   */
  public static String msgHyperlinkSearching() {
    return org.eclipse.osgi.util.NLS.bind(getString(HyperlinkSearching), new Object [] {  });
  }
  
  public final static String InvalidLineNumberIn = "InvalidLineNumberIn";
  
  /**
   * {0} is not a valid line number in {1} 
   */
  public static String msgInvalidLineNumberIn(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(InvalidLineNumberIn), new Object [] { param0, param1 });
  }
  
  public final static String InvalidLineNumberTitle = "InvalidLineNumberTitle";
  
  /**
   * Invalid Line Number
   */
  public static String msgInvalidLineNumberTitle() {
    return org.eclipse.osgi.util.NLS.bind(getString(InvalidLineNumberTitle), new Object [] {  });
  }
  
  public final static String N4JSStackTraceConsole = "N4JSStackTraceConsole";
  
  /**
   * N4JS Stack Trace Console
   */
  public static String msgN4JSStackTraceConsole() {
    return org.eclipse.osgi.util.NLS.bind(getString(N4JSStackTraceConsole), new Object [] {  });
  }
  
  public final static String SourceNotFoundFor = "SourceNotFoundFor";
  
  /**
   * Source not found for {0}
   */
  public static String msgSourceNotFoundFor(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(SourceNotFoundFor), new Object [] { param0 });
  }
  
  public final static String SourceNotFoundTitle = "SourceNotFoundTitle";
  
  /**
   * Source Not Found
   */
  public static String msgSourceNotFoundTitle() {
    return org.eclipse.osgi.util.NLS.bind(getString(SourceNotFoundTitle), new Object [] {  });
  }
  
  public final static String UnableToParseLine = "UnableToParseLine";
  
  /**
   * Unable to parse line number from hyperlink.
   */
  public static String msgUnableToParseLine() {
    return org.eclipse.osgi.util.NLS.bind(getString(UnableToParseLine), new Object [] {  });
  }
  
  public final static String UnableToParseLinkText = "UnableToParseLinkText";
  
  /**
   * Unable to retrieve hyperlink text.
   */
  public static String msgUnableToParseLinkText() {
    return org.eclipse.osgi.util.NLS.bind(getString(UnableToParseLinkText), new Object [] {  });
  }
  
  public final static String UnableToParseType = "UnableToParseType";
  
  /**
   * Unable to parse type name from hyperlink.
   */
  public static String msgUnableToParseType() {
    return org.eclipse.osgi.util.NLS.bind(getString(UnableToParseType), new Object [] {  });
  }
  
  public final static String UpdateConsole = "UpdateConsole";
  
  /**
   * Update N4JS Stack Trace Console
   */
  public static String msgUpdateConsole() {
    return org.eclipse.osgi.util.NLS.bind(getString(UpdateConsole), new Object [] {  });
  }
}
