/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils;

import org.apache.log4j.Logger;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Adds logger declaration (field name "logger") to annotated class.
 * Manual definition:
 * <pre>
 * private final static Logger logger = Logger.getLogger(TYPE.class);
 * </pre>
 */
@SuppressWarnings("all")
public class LogProcessor extends AbstractClassProcessor {
  @Override
  public void doTransform(final MutableClassDeclaration annotatedClass, @Extension final TransformationContext context) {
    this.addLoggerDeclaration(annotatedClass, context);
  }
  
  public MutableFieldDeclaration addLoggerDeclaration(final MutableClassDeclaration cdecl, final TransformationContext context) {
    final Procedure1<MutableFieldDeclaration> _function = (MutableFieldDeclaration it) -> {
      it.setStatic(true);
      it.setFinal(true);
      it.setVisibility(Visibility.PRIVATE);
      it.setType(context.newTypeReference(Logger.class));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(Logger.class);
          _builder.append(".getLogger(");
          _builder.append(cdecl);
          _builder.append(".class)");
        }
      };
      it.setInitializer(_client);
    };
    return cdecl.addField("logger", _function);
  }
}
