/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils.beans;

import com.google.common.base.Objects;
import org.eclipse.n4js.utils.beans.PropertyChangeSupport;
import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.ValidationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Processor for validating all fields that are supposed to NOT participate in property change support.
 */
@SuppressWarnings("all")
public class IgnorePropertyChangeEventsProcessor extends AbstractFieldProcessor {
  @Override
  public void doValidate(final FieldDeclaration field, @Extension final ValidationContext context) {
    final TypeDeclaration clazz = field.getDeclaringType();
    final Function1<AnnotationReference, Boolean> _function = (AnnotationReference it) -> {
      String _qualifiedName = it.getAnnotationTypeDeclaration().getQualifiedName();
      String _name = PropertyChangeSupport.class.getName();
      return Boolean.valueOf(Objects.equal(_qualifiedName, _name));
    };
    final Iterable<? extends AnnotationReference> annotations = IterableExtensions.filter(clazz.getAnnotations(), _function);
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(annotations);
    if (_isNullOrEmpty) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Declaring type is not annotated with @");
      String _simpleName = PropertyChangeSupport.class.getSimpleName();
      _builder.append(_simpleName);
      _builder.append(".");
      context.addError(field, _builder.toString());
      return;
    }
    boolean _isStatic = field.isStatic();
    if (_isStatic) {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("Cannot enable property change support on static field.");
      context.addError(field, _builder_1.toString());
      return;
    }
    boolean _isFinal = field.isFinal();
    if (_isFinal) {
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("Cannot enable property change support on final field.");
      context.addError(field, _builder_2.toString());
      return;
    }
    if (((null != field.getType()) && field.getType().isInferred())) {
      StringConcatenation _builder_3 = new StringConcatenation();
      _builder_3.append("Cannot enable property change support on fields with inferred types.");
      context.addError(field, _builder_3.toString());
      return;
    }
  }
}
