/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils.nodemodel;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.utils.nodemodel.SiblingIterable;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

/**
 * Utility methods for dealing with the parse tree, in addition to those in {@link NodeModelUtils}.
 */
@SuppressWarnings("all")
public class NodeModelUtilsN4 {
  public static ITextRegion findRegionOfKeywordWithOptionalBlock(final ICompositeNode parentNode, final String keyword) {
    final Function1<INode, Boolean> _function = (INode it) -> {
      return Boolean.valueOf(NodeModelUtilsN4.isKeyword(it, keyword));
    };
    final INode keywordNode = IterableExtensions.<INode>findFirst(parentNode.getChildren(), _function);
    if ((keywordNode != null)) {
      INode _nextSibling = keywordNode.getNextSibling();
      final Iterator<INode> siblingsIter = new SiblingIterable(_nextSibling).iterator();
      boolean _hasNext = siblingsIter.hasNext();
      if (_hasNext) {
        final INode nextNode = siblingsIter.next();
        boolean _isKeyword = NodeModelUtilsN4.isKeyword(nextNode, "{");
        if (_isKeyword) {
          final Function1<INode, Boolean> _function_1 = (INode it) -> {
            return Boolean.valueOf(NodeModelUtilsN4.isKeyword(it, "}"));
          };
          final INode closingNode = IteratorExtensions.<INode>findFirst(siblingsIter, _function_1);
          if ((closingNode != null)) {
            int _offset = keywordNode.getOffset();
            int _offset_1 = closingNode.getOffset();
            int _length = closingNode.getLength();
            int _plus = (_offset_1 + _length);
            int _offset_2 = keywordNode.getOffset();
            int _minus = (_plus - _offset_2);
            return new TextRegion(_offset, _minus);
          }
        }
      }
      int _offset_3 = keywordNode.getOffset();
      int _length_1 = keywordNode.getLength();
      return new TextRegion(_offset_3, _length_1);
    }
    return null;
  }
  
  public static boolean isKeyword(final INode node, final String keyword) {
    final EObject ge = node.getGrammarElement();
    boolean _xifexpression = false;
    if ((ge instanceof Keyword)) {
      _xifexpression = keyword.equalsIgnoreCase(((Keyword)ge).getValue());
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }
}
