/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.xpect.config;

import java.util.List;
import org.eclipse.n4js.xpect.config.MemberList;
import org.eclipse.n4js.xpect.config.StringList;
import org.eclipse.n4js.xpect.config.ValueList;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * Variable definition in XpectSetup section. Variables can be part of a {@link Config} or directly defined. A
 * Variable is given a name on construction: <code>VarDef "my_name" {...}</code> Variables then can be used in tests
 * by referencing the name like {@code <$my_name>} The content of the variable it the evalutation of it's content
 * components evaluation in the order they appear.
 * 
 * <p>
 * Possible Content: {@link StringList} or {@link MemberList}
 * 
 * <p>
 * Example:
 * 
 * <pre>
 * VarDef "keywords" {
 *   StringList { s="++" s="--" }
 *   StringList { s="abstract" s="break" }
 * }
 * </pre>
 * 
 * Using {@code <$keywords>} will be evaluated to {@code "++","--","abstract","break"}
 */
@XpectSetupComponent
@SuppressWarnings("all")
public class VarDef {
  public String name;
  
  public List<ValueList> mlist = CollectionLiterals.<ValueList>newArrayList();
  
  /**
   * Constructor requiring a name.
   * 
   * @param name of Variable
   */
  public VarDef(final String name) {
    this.name = name;
  }
  
  /**
   * Conent defined by add Method: MemberLists
   */
  public boolean add(final MemberList l) {
    return this.mlist.add(l);
  }
  
  public boolean add(final StringList s) {
    return this.mlist.add(s);
  }
  
  @Override
  public String toString() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("VarDef[");
    _builder.append(this.name);
    _builder.append("\"|");
    {
      boolean _hasElements = false;
      for(final ValueList m : this.mlist) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        _builder.append(m);
      }
    }
    _builder.append("]");
    return _builder.toString();
  }
}
