/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyAssignmentAnnotationList;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.postprocessing.ASTMetaInfoUtils;
import org.eclipse.n4js.postprocessing.AbstractProcessor;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

abstract class AbstractPolyProcessor
extends AbstractProcessor {
    @Inject
    private N4JSTypeSystem ts;

    AbstractPolyProcessor() {
    }

    public boolean isPoly(EObject obj) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (obj instanceof Expression) {
            _matched = true;
            _switchResult = this.isPoly((Expression)obj);
        }
        if (!_matched && obj instanceof PropertyAssignment) {
            _matched = true;
            _switchResult = this.isPoly((PropertyAssignment)obj);
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isPoly(Expression obj) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (obj instanceof ParameterizedCallExpression) {
            _matched = true;
            boolean _xblockexpression = false;
            boolean _isMigrateCall = MigrationUtils.isMigrateCall((EObject)obj);
            if (_isMigrateCall) {
                return false;
            }
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)obj);
            TypeRef targetTypeRef = this.ts.type(G, (TypableElement)((ParameterizedCallExpression)obj).getTarget());
            boolean _xifexpression = false;
            _xifexpression = targetTypeRef instanceof FunctionTypeExprOrRef ? ((FunctionTypeExprOrRef)targetTypeRef).isGeneric() && ((ParameterizedCallExpression)obj).getTypeArgs().size() < ((FunctionTypeExprOrRef)targetTypeRef).getTypeVars().size() : false;
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched && obj instanceof FunctionExpression) {
            _matched = true;
            boolean bl = _switchResult = IterableExtensions.exists((Iterable)((FunctionExpression)obj).getFpars(), it -> {
                TypeRef _declaredTypeRef = it.getDeclaredTypeRef();
                return _declaredTypeRef == null;
            }) || ((FunctionExpression)obj).getReturnTypeRef() == null;
        }
        if (!_matched && obj instanceof ArrayLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && obj instanceof ObjectLiteral) {
            _matched = true;
            Functions.Function1 _function = it -> this.isPoly((PropertyAssignment)it);
            _switchResult = IterableExtensions.exists((Iterable)((ObjectLiteral)obj).getPropertyAssignments(), (Functions.Function1)_function);
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    private boolean isPoly(PropertyAssignment pa) {
        TypeRef _declaredTypeRef;
        boolean _switchResult = false;
        boolean _matched = false;
        if (pa instanceof PropertyNameValuePair) {
            _matched = true;
            boolean bl = _switchResult = ((PropertyNameValuePair)pa).getExpression() != null && ((PropertyNameValuePair)pa).getDeclaredTypeRef() == null;
        }
        if (!_matched && pa instanceof PropertyGetterDeclaration) {
            _matched = true;
            _declaredTypeRef = ((PropertyGetterDeclaration)pa).getDeclaredTypeRef();
            boolean bl = _switchResult = _declaredTypeRef == null;
        }
        if (!_matched && pa instanceof PropertySetterDeclaration) {
            _matched = true;
            _declaredTypeRef = ((PropertySetterDeclaration)pa).getDeclaredTypeRef();
            boolean bl = _switchResult = _declaredTypeRef == null;
        }
        if (!_matched && pa instanceof PropertyMethodDeclaration) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched && pa instanceof PropertyAssignmentAnnotationList) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            String _name = pa.eClass().getName();
            String _plus = "unsupported subclass of PropertyAssignment: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    public boolean isRootPoly(EObject obj) {
        boolean _xifexpression = false;
        _xifexpression = obj instanceof Expression ? this.isRootPoly((Expression)obj) : false;
        return _xifexpression;
    }

    public boolean isRootPoly(Expression obj) {
        boolean _isPoly = this.isPoly(obj);
        if (_isPoly) {
            EObject p = this.getParentPolyCandidate(obj);
            return p == null || !this.isPoly(p);
        }
        return false;
    }

    private EObject getParentPolyCandidate(Expression poly) {
        boolean _tripleEquals;
        Expression _expression;
        EObject _eContainer = null;
        if (poly != null) {
            _eContainer = poly.eContainer();
        }
        EObject directParent = _eContainer;
        EObject _eContainer_1 = null;
        if (directParent != null) {
            _eContainer_1 = directParent.eContainer();
        }
        EObject grandParent = _eContainer_1;
        EObject _switchResult = null;
        boolean _matched = false;
        if (directParent instanceof Argument && grandParent instanceof ParameterizedCallExpression && ListExtensions.map((List)((ParameterizedCallExpression)grandParent).getArguments(), it -> it.getExpression()).contains(poly)) {
            _matched = true;
            _switchResult = grandParent;
        }
        if (!_matched && directParent instanceof FunctionExpression) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched && directParent instanceof ArrayElement) {
            _expression = ((ArrayElement)directParent).getExpression();
            boolean bl = _tripleEquals = _expression == poly;
            if (_tripleEquals) {
                _matched = true;
                EObject _eContainer_2 = ((ArrayElement)directParent).eContainer();
                _switchResult = (ArrayLiteral)_eContainer_2;
            }
        }
        if (!_matched && directParent instanceof PropertyNameValuePair) {
            _expression = ((PropertyNameValuePair)directParent).getExpression();
            boolean bl = _tripleEquals = _expression == poly;
            if (_tripleEquals) {
                _matched = true;
                _switchResult = directParent;
            }
        }
        if (!_matched && directParent instanceof PropertyGetterDeclaration) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched && directParent instanceof PropertySetterDeclaration) {
            _matched = true;
            _switchResult = null;
        }
        return _switchResult;
    }

    protected TypeRef getFinalResultTypeOfNestedPolyExpression(Expression nestedPolyExpression) {
        return ASTMetaInfoUtils.getTypeFailSafe((TypableElement)nestedPolyExpression);
    }

    protected TypeRef subst(TypeRef typeRef, RuleEnvironment G, Map<TypeVariable, ? extends TypeVariable> substitutions) {
        return this.subst(typeRef, G, substitutions, false);
    }

    protected TypeRef subst(TypeRef typeRef, RuleEnvironment G, Map<TypeVariable, ? extends TypeVariable> substitutions, boolean reverse) {
        RuleEnvironment Gx = RuleEnvironmentExtensions.wrap(G);
        Consumer<Map.Entry> _function = e -> {
            if (reverse) {
                Gx.put(e.getValue(), TypeUtils.createTypeRef((Type)((Type)e.getKey()), (TypeArgument[])new TypeArgument[0]));
            } else {
                Gx.put(e.getKey(), TypeUtils.createTypeRef((Type)((Type)e.getValue()), (TypeArgument[])new TypeArgument[0]));
            }
        };
        substitutions.entrySet().forEach(_function);
        TypeRef typeRefSubst = this.ts.substTypeVariables(Gx, typeRef);
        if (typeRefSubst == null) {
            throw new IllegalArgumentException("substitution failed");
        }
        return typeRefSubst;
    }

    protected TypeRef applySolution(TypeRef typeRef, RuleEnvironment G, Map<InferenceVariable, TypeRef> solution) {
        if (typeRef == null || solution == null || solution.isEmpty()) {
            return typeRef;
        }
        RuleEnvironment Gx = RuleEnvironmentExtensions.wrap(G);
        Consumer<Map.Entry> _function = e -> Gx.put(e.getKey(), e.getValue());
        solution.entrySet().forEach(_function);
        TypeRef typeRefSubst = this.ts.substTypeVariables(Gx, typeRef);
        if (typeRefSubst == null) {
            throw new IllegalArgumentException("substitution failed");
        }
        return typeRefSubst;
    }

    protected Map<InferenceVariable, TypeRef> createPseudoSolution(InferenceContext infCtx, TypeRef defaultTypeRef) {
        HashMap pseudoSolution = CollectionLiterals.newHashMap();
        Set<InferenceVariable> _inferenceVariables = infCtx.getInferenceVariables();
        for (InferenceVariable iv : _inferenceVariables) {
            pseudoSolution.put(iv, defaultTypeRef);
        }
        return pseudoSolution;
    }

    protected boolean isReturningValue(FunctionDefinition fun) {
        boolean _or = false;
        if (fun.getBody() != null && IteratorExtensions.exists((Iterator)fun.getBody().getAllReturnStatements(), it -> {
            Expression _expression = it.getExpression();
            return _expression != null;
        })) {
            _or = true;
        } else {
            boolean _xifexpression = false;
            _xifexpression = fun instanceof ArrowFunction ? ((ArrowFunction)fun).isSingleExprImplicitReturn() : false;
            _or = _xifexpression;
        }
        return _or;
    }

    protected TypeRef getTypeOfMember(TMember m) {
        TypeRef _switchResult = null;
        boolean _matched = false;
        if (m instanceof TField) {
            _matched = true;
            _switchResult = ((TField)m).getTypeRef();
        }
        if (!_matched && m instanceof TGetter) {
            _matched = true;
            _switchResult = ((TGetter)m).getDeclaredTypeRef();
        }
        if (!_matched && m instanceof TSetter) {
            _matched = true;
            TFormalParameter _fpar = null;
            if ((TSetter)m != null) {
                _fpar = ((TSetter)m).getFpar();
            }
            _switchResult = _fpar.getTypeRef();
        }
        if (!_matched && m instanceof TMethod) {
            _matched = true;
            throw new IllegalArgumentException("this method should not be used for TMethod");
        }
        if (!_matched) {
            EClass _eClass = null;
            if (m != null) {
                _eClass = m.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String _plus = "unknown subtype of TMember: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    protected void setTypeOfMember(TMember m, TypeRef type) {
        boolean _matched = false;
        if (m instanceof TField) {
            _matched = true;
            ((TField)m).setTypeRef(type);
        }
        if (!_matched && m instanceof TGetter) {
            _matched = true;
            ((TGetter)m).setDeclaredTypeRef(type);
        }
        if (!_matched && m instanceof TSetter) {
            boolean _tripleNotEquals;
            _matched = true;
            TFormalParameter _fpar = ((TSetter)m).getFpar();
            boolean bl = _tripleNotEquals = _fpar != null;
            if (_tripleNotEquals) {
                TFormalParameter _fpar_1 = ((TSetter)m).getFpar();
                _fpar_1.setTypeRef(type);
            }
        }
        if (!_matched && m instanceof TMethod) {
            _matched = true;
            throw new IllegalArgumentException("this method should not be used for TMethod");
        }
        if (!_matched) {
            EClass _eClass = null;
            if (m != null) {
                _eClass = m.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String _plus = "unknown subtype of TMember: " + _name;
            throw new IllegalArgumentException(_plus);
        }
    }
}

