/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.binaries;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * Representation of a binary status that wraps the actual {@link Binary binary} as well.
 */
@SuppressWarnings("all")
public class BinaryStatus implements IStatus {
  @Delegate
  private final IStatus delegate;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final Binary binary;
  
  public BinaryStatus(final IStatus delegate, final Binary binary) {
    this.delegate = delegate;
    this.binary = binary;
  }
  
  public IStatus[] getChildren() {
    return this.delegate.getChildren();
  }
  
  public int getCode() {
    return this.delegate.getCode();
  }
  
  public Throwable getException() {
    return this.delegate.getException();
  }
  
  public String getMessage() {
    return this.delegate.getMessage();
  }
  
  public String getPlugin() {
    return this.delegate.getPlugin();
  }
  
  public int getSeverity() {
    return this.delegate.getSeverity();
  }
  
  public boolean isMultiStatus() {
    return this.delegate.isMultiStatus();
  }
  
  public boolean isOK() {
    return this.delegate.isOK();
  }
  
  public boolean matches(final int arg0) {
    return this.delegate.matches(arg0);
  }
  
  @Pure
  public Binary getBinary() {
    return this.binary;
  }
}
