/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.n4idl.migrations;

import com.google.common.hash.HashCode;
import java.util.Collections;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * {@link SwitchCondition} which assures that a given value is a reference to a type which is
 * a subtype of {@link #type} (type reference).
 */
@SuppressWarnings("all")
public class TypeTypeCondition extends SwitchCondition {
  public final Type type;
  
  public TypeTypeCondition(final Type type) {
    this.type = type;
  }
  
  @Override
  public int hashCode() {
    return HashCode.fromString(EcoreUtil.getURI(this.type).toString()).asInt();
  }
  
  @Override
  public String getConditionAsString(final String valueIdentifier) {
    return String.format("(%s.constructor instanceof type{%s}", valueIdentifier, SwitchCondition.getTypeDescription(this.type));
  }
  
  @Override
  public Iterable<? extends SwitchCondition> subConditions() {
    return Collections.<SwitchCondition>unmodifiableList(CollectionLiterals.<SwitchCondition>newArrayList());
  }
}
