/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.organize.imports;

import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Utility to find actual name that was used for given reference.
 */
@SuppressWarnings("all")
public class RefNameUtil {
  /**
   * Finds name that is used as identifier.
   */
  public static String findIdentifierName(final IdentifierRef ref) {
    final Function1<ILeafNode, Boolean> _function = (ILeafNode it) -> {
      boolean _isHidden = it.isHidden();
      return Boolean.valueOf((!_isHidden));
    };
    final Function1<ILeafNode, String> _function_1 = (ILeafNode it) -> {
      return it.getText();
    };
    return IterableExtensions.join(IterableExtensions.<ILeafNode, String>map(IterableExtensions.<ILeafNode>filter(NodeModelUtils.findActualNodeFor(ref).getLeafNodes(), _function), _function_1));
  }
  
  /**
   * Finds the name in the ParameterizedTypeRef.
   * @return null if no connection to AST
   */
  public static String findTypeName(final ParameterizedTypeRef ref) {
    Object _xblockexpression = null;
    {
      final ICompositeNode astNode = NodeModelUtils.findActualNodeFor(ref);
      Object _xifexpression = null;
      if ((astNode != null)) {
        int prefixLen = 0;
        int suffixLen = 0;
        final Function1<ILeafNode, Boolean> _function = (ILeafNode it) -> {
          boolean _isHidden = it.isHidden();
          return Boolean.valueOf((!_isHidden));
        };
        final Function1<ILeafNode, String> _function_1 = (ILeafNode it) -> {
          return it.getText();
        };
        final String nodeText = IterableExtensions.join(IterableExtensions.<ILeafNode, String>map(IterableExtensions.<ILeafNode>filter(astNode.getLeafNodes(), _function), _function_1));
        boolean _equals = ref.getDefinedTypingStrategy().equals(TypingStrategy.NOMINAL);
        boolean _not = (!_equals);
        if (_not) {
          final String typingLiteral = ref.getDefinedTypingStrategy().getLiteral();
          boolean _startsWith = nodeText.startsWith(typingLiteral);
          if (_startsWith) {
            prefixLen = ref.getDefinedTypingStrategy().getLiteral().length();
          }
        }
        if ((ref.isFollowedByQuestionMark() && nodeText.endsWith("?"))) {
          suffixLen = 1;
        }
        if ((ref.isDynamic() && nodeText.endsWith("+"))) {
          suffixLen = 1;
        }
        int _length = nodeText.length();
        int _minus = (_length - suffixLen);
        return nodeText.substring(prefixLen, _minus);
      } else {
        _xifexpression = null;
      }
      _xblockexpression = _xifexpression;
    }
    return ((String)_xblockexpression);
  }
}
