/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.validation.JavaScriptVariant;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.testing.util.ResourceHelper;
import org.junit.Assert;

public class N4JSParseHelper
extends ParseHelper<Script> {
    @Inject
    private ResourceHelper resourceHelper;
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public Script parseUnrestricted(CharSequence text) throws Exception {
        return this.parse(text, JavaScriptVariant.unrestricted);
    }

    public Script parseStrict(CharSequence text) throws Exception {
        return this.parse(text, JavaScriptVariant.strict);
    }

    public Script parseN4js(CharSequence text) throws Exception {
        return this.parse(text, JavaScriptVariant.n4js);
    }

    public Script parse(CharSequence text, JavaScriptVariant variant) throws Exception {
        try {
            Script script;
            switch (variant) {
                case external: {
                    Script script2;
                    this.setFileExtension("n4jsd");
                    Script script3 = script2 = (Script)this.parse(text);
                    return script3;
                }
                case n4js: {
                    Script script4;
                    this.setFileExtension("n4js");
                    Script script5 = script4 = (Script)this.parse(text);
                    return script5;
                }
                case strict: {
                    Script script6;
                    this.setFileExtension("js");
                    Script script7 = script6 = (Script)this.parse("\"scrict mode\"\n" + text);
                    return script7;
                }
                case n4idl: {
                    Script script8;
                    this.setFileExtension("n4idl");
                    Script script9 = script8 = (Script)this.parse(text);
                    return script9;
                }
            }
            this.setFileExtension("js");
            Script script10 = script = (Script)this.parse(text);
            return script10;
        }
        finally {
            this.resourceHelper.setFileExtensionProvider(this.fileExtensionProvider);
        }
    }

    protected URI computeUnusedUri(ResourceSet resourceSet) {
        String name = "__synthetic";
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            URI syntheticUri = URI.createURI((String)(String.valueOf(name) + i + "." + this.fileExtension));
            if (resourceSet.getResource(syntheticUri, false) == null) {
                return syntheticUri;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public void assertNoParseErrors(Script script) {
        Assert.assertTrue((String)Joiner.on((char)'\n').join((Iterable)script.eResource().getErrors()), (boolean)script.eResource().getErrors().isEmpty());
    }

    private void setFileExtension(String ext) {
        FileExtensionProvider dummy = new FileExtensionProvider(ext){
            {
                this.setExtensions(string);
            }
        };
        this.resourceHelper.setFileExtensionProvider(dummy);
        this.fileExtension = ext;
    }
}

