/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.n4idl;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.transpiler.es.n4idl.assistants.MigrationTransformationAssistant;
import org.eclipse.n4js.transpiler.es.n4idl.assistants.N4IDLClassifierTransformationAssistant;
import org.eclipse.n4js.transpiler.es.transform.ClassDeclarationTransformation;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * N4IDL-specific {@link ClassDeclarationTransformation} which additionally
 * initializes a class declaration with migration-support related static fields.
 */
@SuppressWarnings("all")
public class N4IDLClassDeclarationTransformation extends ClassDeclarationTransformation {
  @Inject
  @Extension
  private MigrationTransformationAssistant _migrationTransformationAssistant;
  
  @Inject
  @Extension
  private N4IDLClassifierTransformationAssistant _n4IDLClassifierTransformationAssistant;
  
  @Override
  protected List<Statement> createStaticFieldInitializations(final SymbolTableEntry steClass, final N4ClassDeclaration classDecl) {
    final List<Statement> statements = super.createStaticFieldInitializations(steClass, classDecl);
    statements.add(this._migrationTransformationAssistant.createMigrationSupportInitializer(steClass, classDecl));
    statements.add(this._n4IDLClassifierTransformationAssistant.createImplementedInterfaceStaticInitializer(steClass, classDecl));
    return statements;
  }
}
