/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.MemberAccess;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.organize.imports.ImportStateCalculator;
import org.eclipse.n4js.organize.imports.RecordingImportState;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.scoping.accessModifiers.TypeVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.VariableVisibilityChecker;
import org.eclipse.n4js.scoping.utils.ImportSpecifierUtil;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ui.contentassist.N4JSCandidateFilter;
import org.eclipse.n4js.ui.organize.imports.BreakException;
import org.eclipse.n4js.ui.organize.imports.DisambiguateUtil;
import org.eclipse.n4js.ui.organize.imports.ImportDeclarationTextHelper;
import org.eclipse.n4js.ui.organize.imports.ImportProvidedElementLabelprovider;
import org.eclipse.n4js.ui.organize.imports.ImportableObject;
import org.eclipse.n4js.ui.organize.imports.ImportsFactory;
import org.eclipse.n4js.ui.organize.imports.ImportsSorter;
import org.eclipse.n4js.ui.organize.imports.Interaction;
import org.eclipse.n4js.ui.organize.imports.UnresolveProxyCrossRefHelper;
import org.eclipse.n4js.ui.organize.imports.XtextResourceUtils;
import org.eclipse.n4js.utils.Log;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;

@Log
public class ImportsComputer {
    @Inject
    private ImportStateCalculator importStateCalculator;
    @Inject
    private ImportsFactory importsFactory;
    @Inject
    private ImportProvidedElementLabelprovider importProvidedElementLabelprovider;
    @Inject
    private N4JSCandidateFilter candidateFilter;
    @Inject
    private IN4JSCore core;
    @Inject
    private ImportDeclarationTextHelper declarationTextHelper;
    @Inject
    private TypeVisibilityChecker typeVisibilityChecker;
    @Inject
    private VariableVisibilityChecker varVisibilityChecker;
    @Inject
    private UnresolveProxyCrossRefHelper crossRef;
    private final Adapter nodelessMarker = new AdapterImpl();
    private static final Logger logger = Logger.getLogger(ImportsComputer.class);

    public String getOrganizedImportSection(XtextResource xtextResource, String lineEnding, Interaction interaction) throws BreakException {
        boolean _greaterThan;
        StringBuilder sb = new StringBuilder();
        Script script = XtextResourceUtils.getScript(xtextResource);
        List resultingImports = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class));
        RecordingImportState reg = this.importStateCalculator.calculateImportstate(script);
        reg.removeDuplicatedImportDeclarations(resultingImports);
        reg.removeLocalNameCollisions(resultingImports, this.nodelessMarker);
        reg.removeDuplicatedImportsOfSameelement(resultingImports, this.nodelessMarker);
        reg.removeBrokenImports(resultingImports, this.nodelessMarker);
        reg.removeUnusedImports(resultingImports, this.nodelessMarker);
        Set brokenNames = reg.calcRemovedImportedNames();
        ArrayList<ImportDeclaration> _resolveMissingImports = this.resolveMissingImports(script, brokenNames, interaction);
        Iterables.addAll((Collection)resultingImports, _resolveMissingImports);
        Consumer<ImportDeclaration> _function = it -> EcoreUtil.resolveAll((EObject)it);
        resultingImports.forEach(_function);
        ImportsSorter.sortByImport(resultingImports);
        Consumer<ImportDeclaration> _function_1 = it -> {
            String text = this.declarationTextHelper.extractPureText((ImportDeclaration)it, xtextResource, this.nodelessMarker);
            sb.append(text).append(lineEnding);
        };
        resultingImports.forEach(_function_1);
        int length = sb.length();
        int _length = lineEnding.length();
        boolean bl = _greaterThan = length > _length;
        if (_greaterThan) {
            int _length_1 = lineEnding.length();
            int _minus = length - _length_1;
            sb.delete(_minus, length);
        }
        return sb.toString();
    }

    private ArrayList<ImportDeclaration> resolveMissingImports(Script script, Set<String> namesThatWeBroke, Interaction interaction) throws BreakException {
        IN4JSProject contextProject = (IN4JSProject)this.core.findProject(script.eResource().getURI()).orNull();
        Multimap<String, ImportableObject> resolutions = this.createResolutionsForBrokenNames(script, contextProject, namesThatWeBroke);
        Functions.Function2 _function = (p1, p2) -> {
            int _size = p2.size();
            return _size == 1;
        };
        Map solutions = MapExtensions.filter((Map)resolutions.asMap(), (Functions.Function2)_function);
        ArrayList ret = CollectionLiterals.newArrayList();
        BiConsumer<String, Collection> _function_1 = (name, importable) -> {
            ImportableObject imp = (ImportableObject)IterableExtensions.head((Iterable)importable);
            ret.add(this.importsFactory.createImport(imp, contextProject, this.nodelessMarker));
        };
        solutions.forEach(_function_1);
        namesThatWeBroke.removeAll(solutions.keySet());
        Functions.Function2 _function_2 = (p1, p2) -> {
            int _size = p2.size();
            return _size > 1;
        };
        Map ambiguousSolution = MapExtensions.filter((Map)resolutions.asMap(), (Functions.Function2)_function_2);
        LinkedHashMultimap forDisambiguation = LinkedHashMultimap.create();
        BiConsumer<String, Collection> _function_3 = (arg_0, arg_1) -> ImportsComputer.lambda$5((Multimap)forDisambiguation, arg_0, arg_1);
        ambiguousSolution.forEach(_function_3);
        HashSet resolved = new HashSet();
        Consumer<String> _function_4 = arg_0 -> this.lambda$6((Multimap)forDisambiguation, ret, contextProject, resolved, arg_0);
        forDisambiguation.keySet().forEach(_function_4);
        Consumer<String> _function_5 = arg_0 -> ImportsComputer.lambda$8((Multimap)forDisambiguation, arg_0);
        resolved.forEach(_function_5);
        List<ImportableObject> chosenSolutions = DisambiguateUtil.disambiguate(forDisambiguation, interaction, this.importProvidedElementLabelprovider);
        Consumer<ImportableObject> _function_6 = it -> ret.add(this.importsFactory.createImport((ImportableObject)it, contextProject, this.nodelessMarker));
        chosenSolutions.forEach(_function_6);
        return ret;
    }

    private Multimap<String, ImportableObject> createResolutionsForBrokenNames(Script script, IN4JSProject contextProject, Set<String> namesThatWeBroke) {
        LinkedHashMultimap resolutions = LinkedHashMultimap.create();
        Functions.Function1 _function = it -> Boolean.valueOf(it.eobject instanceof MemberAccess) == Boolean.valueOf(false);
        Iterable unresolved = IterableExtensions.filter(this.crossRef.findProxyCrossRefInfo(script), (Functions.Function1)_function);
        HashSet<String> brokenNames = new HashSet<String>();
        brokenNames.addAll(namesThatWeBroke);
        Functions.Function1 _function_1 = it -> it.name;
        Iterables.addAll(brokenNames, (Iterable)IterableExtensions.map((Iterable)unresolved, (Functions.Function1)_function_1));
        this.addResolutionsFromIndex((Multimap<String, ImportableObject>)resolutions, contextProject, brokenNames, script.eResource());
        return resolutions;
    }

    private void addResolutionsFromIndex(Multimap<String, ImportableObject> resolution, IN4JSProject contextProject, Iterable<String> brokenNames, Resource contextResource) {
        ResourceSet resourceSet = this.core.createResourceSet(Optional.fromNullable((Object)contextProject));
        Iterable resources = this.core.getXtextIndex(resourceSet).getAllResourceDescriptions();
        Consumer<IResourceDescription> _function = res -> {
            IN4JSProject candidateProject = (IN4JSProject)this.core.findProject(res.getURI()).orNull();
            if (candidateProject != null) {
                boolean _tripleNotEquals;
                IN4JSProject _dependencyWithID = ImportSpecifierUtil.getDependencyWithID((String)candidateProject.getProjectName(), (IN4JSProject)contextProject);
                boolean bl = _tripleNotEquals = _dependencyWithID != null;
                if (_tripleNotEquals) {
                    for (IEObjectDescription ieod : res.getExportedObjects()) {
                        boolean _isNotModule = this.isNotModule(ieod.getEObjectURI());
                        if (!_isNotModule) continue;
                        Consumer<String> _function_1 = usedName -> {
                            if (this.candidateFilter.apply(ieod) && this.isCandidate(ieod, (String)usedName) && this.isVisible(ieod, contextResource)) {
                                this.add(resolution, (String)usedName, ieod, contextResource);
                            }
                        };
                        brokenNames.forEach(_function_1);
                    }
                }
            }
        };
        resources.forEach(_function);
    }

    private boolean add(Multimap<String, ImportableObject> resolution, String usedName, IEObjectDescription ieoDescription, Resource contextResource) {
        boolean _contains = usedName.contains(".");
        if (_contains) {
            Object _last;
            boolean _notEquals_1;
            boolean _notEquals;
            String[] segments = usedName.split("\\.");
            int _size = ((List)Conversions.doWrapArray((Object)segments)).size();
            boolean bl = _notEquals = _size != 2;
            if (_notEquals) {
                return false;
            }
            EObject eo = this.tryGetEObjectOrProxy(ieoDescription.getEObjectOrProxy(), contextResource);
            if (Boolean.valueOf(eo instanceof TExportableElement) == Boolean.valueOf(false)) {
                return false;
            }
            String _exportedName = ((TExportableElement)eo).getExportedName();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_exportedName, (Object)(_last = IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)segments)))));
            if (_notEquals_1) {
                return false;
            }
            String _head = (String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)segments)));
            String _head_1 = (String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)segments)));
            boolean _isDefaultExport = this.isDefaultExport(ieoDescription, contextResource);
            ImportableObject _importableObject = new ImportableObject(_head_1, (TExportableElement)eo, _isDefaultExport, true);
            return resolution.put((Object)_head, (Object)_importableObject);
        }
        EObject eo_1 = this.tryGetEObjectOrProxy(ieoDescription.getEObjectOrProxy(), contextResource);
        boolean _isDefaultExport_1 = this.isDefaultExport(ieoDescription, contextResource);
        ImportableObject _importableObject_1 = new ImportableObject(usedName, (TExportableElement)eo_1, _isDefaultExport_1);
        return resolution.put((Object)usedName, (Object)_importableObject_1);
    }

    private boolean isDefaultExport(IEObjectDescription description, Resource contextResource) {
        EObject eo = this.tryGetEObjectOrProxy(description.getEObjectOrProxy(), contextResource);
        if (eo instanceof TExportableElement) {
            String _exportedName = ((TExportableElement)eo).getExportedName();
            return Objects.equal((Object)_exportedName, (Object)"default");
        }
        return false;
    }

    private boolean isCandidate(IEObjectDescription description, String usedName) {
        String[] segments;
        QualifiedName qName = description.getName();
        String _lastSegment = qName.getLastSegment();
        boolean _equals = Objects.equal((Object)_lastSegment, (Object)usedName);
        if (_equals) {
            return true;
        }
        boolean _contains = usedName.contains(".");
        if (_contains && ((List)Conversions.doWrapArray((Object)(segments = usedName.split("\\.")))).size() == 2 && Objects.equal((Object)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)segments))), (Object)qName.getLastSegment())) {
            return true;
        }
        if (Objects.equal((Object)qName.getLastSegment(), (Object)"default") && qName.getSegmentCount() > 1) {
            int _segmentCount = qName.getSegmentCount();
            int _minus = _segmentCount - 2;
            String moduleName = qName.getSegment(_minus).toLowerCase();
            String usedSimpleName = usedName.toLowerCase();
            boolean _equals_1 = Objects.equal((Object)usedSimpleName, (Object)moduleName);
            if (_equals_1) {
                return true;
            }
            String simplifiedModuleName = moduleName.replaceAll("-|_", "");
            boolean _equals_2 = Objects.equal((Object)usedSimpleName, (Object)simplifiedModuleName);
            if (_equals_2) {
                return true;
            }
        }
        return false;
    }

    private EObject tryGetEObjectOrProxy(EObject eobject, Resource contextResource) {
        EObject eo = eobject;
        boolean _eIsProxy = eo.eIsProxy();
        if (_eIsProxy) {
            eo = EcoreUtil.resolve((EObject)eo, (Resource)contextResource);
            String data = "";
            boolean _eIsProxy_1 = eo.eIsProxy();
            if (_eIsProxy_1) {
                if (eo instanceof TClass) {
                    String _plus;
                    String _name = ((TClass)eo).getName();
                    data = _plus = String.valueOf(_name) + " ";
                }
                logger.warn((Object)("Cannot resolve proxy " + data + eo));
            }
        }
        return eo;
    }

    private boolean isNotModule(URI uri) {
        boolean res;
        String _fragment = null;
        if (uri != null) {
            _fragment = uri.fragment();
        }
        return !(res = _fragment.endsWith("/1"));
    }

    private boolean isVisible(IEObjectDescription ieod, Resource contextResource) {
        EObject eo = this.tryGetEObjectOrProxy(ieod.getEObjectOrProxy(), contextResource);
        if (eo instanceof Type && this.isSubtypeOfType(eo.eClass())) {
            return this.typeVisibilityChecker.isVisible((Resource)contextResource, (Type)((Type)eo)).visibility;
        }
        if (eo instanceof TVariable && this.isSubtypeOfIdentifiable(eo.eClass())) {
            return this.varVisibilityChecker.isVisible((Resource)contextResource, (TVariable)((TVariable)eo)).visibility;
        }
        return false;
    }

    protected boolean isSubtypeOfIdentifiable(EClass type) {
        return type == TypesPackage.Literals.IDENTIFIABLE_ELEMENT || type.getEPackage() == TypesPackage.eINSTANCE && TypesPackage.Literals.IDENTIFIABLE_ELEMENT.isSuperTypeOf(type);
    }

    protected boolean isSubtypeOfType(EClass type) {
        return type == TypesPackage.Literals.TYPE || type.getEPackage() == TypesPackage.eINSTANCE && TypesPackage.Literals.TYPE.isSuperTypeOf(type);
    }

    private static /* synthetic */ void lambda$5(Multimap multimap, String p1, Collection p2) {
        multimap.putAll((Object)p1, (Iterable)p2);
    }

    private /* synthetic */ void lambda$6(Multimap multimap, ArrayList arrayList, IN4JSProject iN4JSProject, HashSet hashSet, String key) {
        Functions.Function1 _function_5;
        Collection multiSolutions = multimap.get((Object)key);
        boolean containsOnlyNamespaces = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)multiSolutions, (Functions.Function1)(_function_5 = it -> {
            boolean _isAsNamespace = it.isAsNamespace();
            return !_isAsNamespace;
        })));
        if (containsOnlyNamespaces) {
            arrayList.add(this.importsFactory.createImport((ImportableObject)IterableExtensions.head((Iterable)multiSolutions), iN4JSProject, this.nodelessMarker));
            hashSet.add(key);
        }
    }

    private static /* synthetic */ void lambda$8(Multimap multimap, String key) {
        multimap.removeAll((Object)key);
    }
}

