/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.xpect.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.n4js.xpect.config.ValueList;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * Compose a simple list of Strings. The order of elements is preserved. For the time being just add them with the
 * following syntax in the body:
 * <pre><code>
 * StringList {
 *   s="++"
 *   s="--"
 *   s="abstract"
 *   s="break"
 * }
 * </code><pre>
 * A StringList can be used inside of {@link VarDef}. See also {@link MemberList} and {@link Config}.
 */
@XpectSetupComponent
@SuppressWarnings("all")
public class StringList implements ValueList {
  private ArrayList<String> strings;
  
  public StringList() {
    this.strings = CollectionLiterals.<String>newArrayList();
  }
  
  public StringList(final String... x) {
    this.strings = CollectionLiterals.<String>newArrayList(x);
  }
  
  public boolean add(final String s) {
    return this.strings.add(s);
  }
  
  public boolean setS(final String s) {
    return this.strings.add(s);
  }
  
  @Override
  public List<String> evaluate(final XtextResource res) {
    return this.strings;
  }
}
