/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.common;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.generator.AbstractSubGenerator;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.transpiler.es.EcmaScriptSubGenerator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class XpectN4JSES5GeneratorHelper {
    private static final String NL = "\n";
    @Inject
    private IResourceValidator resourceValidator;

    public String compile(Script depRoot, GeneratorOption[] options, boolean replaceQuotes) {
        Resource resource = depRoot.eResource();
        EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
        AbstractSubGenerator generator = this.getGeneratorForResource(resource);
        String compileResultStr = generator.getCompileResultAsText(depRoot, options);
        if (replaceQuotes) {
            compileResultStr = compileResultStr.replace("\"", "'");
        }
        return compileResultStr;
    }

    public boolean isCompilable(Resource resource, StringBuilder errorResult) {
        AbstractSubGenerator generator = this.getGeneratorForResource(resource);
        return generator.shouldBeCompiled(resource, CancelIndicator.NullImpl) || !this.registerErrors(resource, errorResult);
    }

    private boolean registerErrors(Resource dep, StringBuilder errorResult) {
        boolean hasErrors = false;
        List issues = this.resourceValidator.validate(dep, CheckMode.ALL, CancelIndicator.NullImpl);
        ArrayList<Issue> errorIssues = new ArrayList<Issue>();
        for (Issue issue : issues) {
            if (Severity.ERROR != issue.getSeverity()) continue;
            errorIssues.add(issue);
        }
        boolean bl = hasErrors = !errorIssues.isEmpty();
        if (hasErrors) {
            errorResult.append("Couldn't compile resource " + dep.getURI() + " because it contains errors: ");
            for (Issue errorIssue : errorIssues) {
                errorResult.append(NL + errorIssue.getMessage() + " at line " + errorIssue.getLineNumber());
            }
        }
        return hasErrors;
    }

    private AbstractSubGenerator getGeneratorForResource(Resource resource) {
        Preconditions.checkState((boolean)(resource instanceof XtextResource), (Object)("Expected XtextResource was " + resource));
        return (AbstractSubGenerator)((XtextResource)resource).getResourceServiceProvider().get(EcmaScriptSubGenerator.class);
    }
}

