/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NodeProcessBuilder;
import org.eclipse.n4js.utils.process.OutputRedirection;
import org.eclipse.n4js.utils.process.ProcessExecutionCommand;
import org.eclipse.n4js.utils.process.ProcessExecutor;
import org.eclipse.n4js.utils.process.ProcessResult;

@Singleton
public class BinaryCommandFactory {
    @Inject
    private ProcessExecutor processExecutor;
    @Inject
    private NodeProcessBuilder nodeProccessBuilder;

    public ProcessExecutionCommand createInstallPackageCommand(File invocationPath, String packageName, boolean saveDependency) {
        return this.createInstallPackageCommand(invocationPath, Collections.singletonList(packageName), saveDependency);
    }

    public ProcessExecutionCommand createInstallPackageCommand(final File invocationPath, final List<String> packageNames, final boolean saveDependency) {
        return new ProcessExecutionCommand(){
            private static final String COMMAND_NAME = "npm_install";

            public ProcessResult execute() {
                String escapedPackageNames = !packageNames.isEmpty() ? "\"" + Joiner.on((String)"\" \"").join((Iterable)packageNames) + "\"" : null;
                boolean actualSaveDependency = saveDependency && !packageNames.isEmpty();
                ProcessBuilder processBuilder = BinaryCommandFactory.this.nodeProccessBuilder.getNpmInstallProcessBuilder(invocationPath, escapedPackageNames, actualSaveDependency);
                return BinaryCommandFactory.this.processExecutor.createAndExecute(processBuilder, COMMAND_NAME, OutputRedirection.REDIRECT);
            }
        };
    }

    public ProcessExecutionCommand createUninstallPackageCommand(final File invocationPath, final List<String> packageNames, final boolean saveDependency) {
        return new ProcessExecutionCommand(){
            private static final String COMMAND_NAME = "npm_uninstall";

            public ProcessResult execute() {
                String escapedPackageNames = "\"" + Joiner.on((String)"\" \"").join((Iterable)packageNames) + "\"";
                ProcessBuilder processBuilder = BinaryCommandFactory.this.nodeProccessBuilder.getNpmUninstallProcessBuilder(invocationPath, escapedPackageNames, saveDependency);
                return BinaryCommandFactory.this.processExecutor.createAndExecute(processBuilder, COMMAND_NAME, OutputRedirection.REDIRECT);
            }
        };
    }

    public ProcessExecutionCommand createCacheCleanCommand(final File invocationPath) {
        return new ProcessExecutionCommand(){
            private static final String COMMAND_NAME = "npm_cache_clean";

            public ProcessResult execute() {
                ProcessBuilder processBuilder = BinaryCommandFactory.this.nodeProccessBuilder.getNpmCacheCleanProcessBuilder(invocationPath);
                return BinaryCommandFactory.this.processExecutor.createAndExecute(processBuilder, COMMAND_NAME, OutputRedirection.REDIRECT);
            }
        };
    }

    public ProcessExecutionCommand checkBinaryVersionCommand(final Binary binary) {
        return new ProcessExecutionCommand(){

            public ProcessResult execute() {
                ProcessBuilder processBuilder = BinaryCommandFactory.this.nodeProccessBuilder.createVersionCheckProcess(binary);
                return BinaryCommandFactory.this.processExecutor.createAndExecute(processBuilder, binary.getLabel(), OutputRedirection.SUPPRESS);
            }
        };
    }
}

