/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Strings;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public enum ResourceType {
    JS,
    JSX,
    N4JS,
    N4JSX,
    N4JSD,
    XT,
    N4IDL,
    UNKOWN;

    private static final String EXT_JS = "js";
    private static final String EXT_JSX = "jsx";
    private static final String EXT_N4JS = "n4js";
    private static final String EXT_N4JSX = "n4jsx";
    private static final String EXT_N4JSD = "n4jsd";
    private static final String EXT_XT = "xt";
    private static final String EXT_N4IDL = "n4idl";

    public static ResourceType getResourceType(EObject eObject) {
        if (eObject == null) {
            return UNKOWN;
        }
        return ResourceType.getResourceType(eObject.eResource());
    }

    public static ResourceType getResourceType(Resource resource) {
        if (resource == null) {
            return UNKOWN;
        }
        return ResourceType.getResourceType(resource.getURI());
    }

    public static ResourceType getResourceType(URI uri) {
        if (uri == null) {
            return UNKOWN;
        }
        ResourceType resourceType = ResourceType.naiveGetResourceType(uri);
        switch (resourceType) {
            case XT: {
                return ResourceType.naiveGetResourceType(uri.trimFileExtension());
            }
        }
        return resourceType;
    }

    public static boolean xtHidesOtherExtension(URI uri) {
        if (uri == null) {
            return false;
        }
        ResourceType resourceType = ResourceType.naiveGetResourceType(uri);
        switch (resourceType) {
            case XT: {
                ResourceType innerResourceType = ResourceType.naiveGetResourceType(uri.trimFileExtension());
                return !XT.equals((Object)innerResourceType) && !UNKOWN.equals((Object)innerResourceType);
            }
        }
        return false;
    }

    private static ResourceType naiveGetResourceType(URI uri) {
        String fileExtension = uri.fileExtension();
        if (Strings.isNullOrEmpty((String)fileExtension)) {
            return UNKOWN;
        }
        switch (fileExtension.toLowerCase()) {
            case "js": {
                return JS;
            }
            case "jsx": {
                return JSX;
            }
            case "n4js": {
                return N4JS;
            }
            case "n4jsx": {
                return N4JSX;
            }
            case "n4jsd": {
                return N4JSD;
            }
            case "xt": {
                return XT;
            }
            case "n4idl": {
                return N4IDL;
            }
        }
        return UNKOWN;
    }
}

