/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.validation.JavaScriptVariant;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;

@Singleton
public class BaseJavaScriptVariantHelper
implements JavaScriptVariantHelper {
    public static final String STRICT_MODE_LITERAL_VALUE = "use strict";
    public static final String EXT_JS = "js";
    @Inject
    protected XpectAwareFileExtensionCalculator fileExtensionCalculator;
    public static final ValidationFeature<String> VARIANT_NAME = new ValidationFeature<String>("<Unknown JavaScript Variant>");
    public static final ValidationFeature<Boolean> DYNAMIC_PSEUDO_SCOPE = new ValidationFeature<Boolean>(true);
    public static final ValidationFeature<Boolean> ALLOW_MISSING_IMPLEMENTATION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_OVERRIDE_ANNOTATION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_TYPE_DECLARATION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_MEMBER_DECLARATION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_VARIABLE = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_METHOD_REFERENCE = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_CALL_EXPRESSION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_NEW_EXPRESSION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_INDEXED_ACCESS_EXPRESSION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_FUNCTION_NAME = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_FUNCTION_RETURN = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_FUNCTION_EXPRESSION_IN_EXRESSION_STATEMENTMEMBER_DECLARATION = new ValidationFeature<Boolean>(true);
    public static final ValidationFeature<Boolean> CONSTANT_HAS_INITIALIZER = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_NO_N4JS_IN_RUNTIME_ENV_OR_LIB = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> ALLOW_WRONG_READ_WRITE = new ValidationFeature<Boolean>(true);
    public static final ValidationFeature<Boolean> DOOM_TYPE_INTERFENCE = new ValidationFeature<Boolean>(true);
    public static final ValidationFeature<Boolean> ALLOW_ANNOTATION = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_FINAL_FIELDS_IS_INITIALIZED = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_NAME_START_WITH_DOLLAR = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_MISSING_BODY = new ValidationFeature<Boolean>(true);
    public static final ValidationFeature<Boolean> ENFORCE_DYNAMIC_TYPES = new ValidationFeature<Boolean>(true);
    public static final ValidationFeature<Boolean> TYPE_AWARE = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> CHECK_EXPORTED_WHEN_VISIBILITY_HIGHER_THAN_PRIVATE = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> EXTERNAL_MODE = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> IS_N4JS_MODE = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> IS_PLAIN_JS = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<String> VARIANT_MODE_STRINGREP = new ValidationFeature<String>("js");
    public static final ValidationFeature<Boolean> MULTI_QN_SCOPE = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> VERSIONED_TYPES = new ValidationFeature<Boolean>(false);
    public static final ValidationFeature<Boolean> TOP_LEVEL_STATEMENTS = new ValidationFeature<Boolean>(true);
    private final Map<FileExtensionValidationFeaturePair, Object> table = new HashMap<FileExtensionValidationFeaturePair, Object>();
    protected BaseJavaScriptVariantHelper next;

    protected BaseJavaScriptVariantHelper() {
        this.addEntry(EXT_JS, IS_PLAIN_JS, true);
    }

    protected <T> void addEntry(String fileExtension, ValidationFeature<T> feature, T value) {
        Objects.requireNonNull(fileExtension);
        Objects.requireNonNull(feature);
        Objects.requireNonNull(value);
        this.table.put(new FileExtensionValidationFeaturePair(fileExtension, feature), value);
    }

    protected <T> T get(String fileExtension, ValidationFeature<T> feature) {
        T result = feature.get(this.table, fileExtension);
        if (result != null) {
            return result;
        }
        if (this.next != null) {
            return this.next.get(fileExtension, feature);
        }
        return feature.getDefaultValue();
    }

    @Override
    public boolean activateDynamicPseudoScope(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), DYNAMIC_PSEUDO_SCOPE);
    }

    @Override
    public boolean allowMissingImplementation(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), ALLOW_MISSING_IMPLEMENTATION);
    }

    @Override
    public boolean checkOverrideAnnotation(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_OVERRIDE_ANNOTATION);
    }

    @Override
    public boolean checkTypeDeclaration(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_TYPE_DECLARATION);
    }

    @Override
    public boolean checkMemberDeclaration(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_MEMBER_DECLARATION);
    }

    @Override
    public boolean checkVariable(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_VARIABLE);
    }

    @Override
    public boolean checkMethodReference(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_METHOD_REFERENCE);
    }

    @Override
    public boolean checkCallExpression(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_CALL_EXPRESSION);
    }

    @Override
    public boolean requireCheckNewExpression(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_NEW_EXPRESSION);
    }

    @Override
    public boolean requireCheckIndexedAccessExpression(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_INDEXED_ACCESS_EXPRESSION);
    }

    @Override
    public boolean requireCheckFunctionName(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_FUNCTION_NAME);
    }

    @Override
    public boolean requireCheckFunctionReturn(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_FUNCTION_RETURN);
    }

    @Override
    public boolean requireCheckFunctionExpressionInExpressionStatement(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_FUNCTION_EXPRESSION_IN_EXRESSION_STATEMENTMEMBER_DECLARATION);
    }

    @Override
    public boolean constantHasInitializer(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CONSTANT_HAS_INITIALIZER);
    }

    @Override
    public boolean requirecheckNoN4jsInRuntimeEnvOrLib(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_NO_N4JS_IN_RUNTIME_ENV_OR_LIB);
    }

    @Override
    public boolean allowWrongReadWrite(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), ALLOW_WRONG_READ_WRITE);
    }

    @Override
    public boolean doomTypeInference(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), DOOM_TYPE_INTERFENCE);
    }

    @Override
    public boolean allowAnnotation(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), ALLOW_ANNOTATION);
    }

    @Override
    public boolean requireCheckFinalFieldIsInitialized(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_FINAL_FIELDS_IS_INITIALIZED);
    }

    @Override
    public boolean requireCheckNameStartsWithDollar(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_NAME_START_WITH_DOLLAR);
    }

    @Override
    public boolean requireCheckForMissingBody(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_MISSING_BODY);
    }

    @Override
    public boolean requireCheckTypeMatchesExpectedType(EObject eobj) {
        return !this.isUnrestrictedMode(eobj);
    }

    @Override
    public boolean enforceDynamicTypes(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), ENFORCE_DYNAMIC_TYPES);
    }

    @Override
    public boolean isTypeAware(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), TYPE_AWARE);
    }

    @Override
    public boolean hasGlobalObject(EObject eobj) {
        return this.isUnrestrictedMode(eobj);
    }

    @Override
    public boolean requireCheckExportedWhenVisibilityHigherThanPrivate(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), CHECK_EXPORTED_WHEN_VISIBILITY_HIGHER_THAN_PRIVATE);
    }

    @Override
    public boolean isUnrestrictedMode(EObject eobj) {
        return !this.isStrictMode(eobj);
    }

    @Override
    public boolean isExternalMode(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), EXTERNAL_MODE);
    }

    @Override
    public boolean isN4JSMode(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), IS_N4JS_MODE);
    }

    @Override
    public boolean isPlainJS(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), IS_PLAIN_JS);
    }

    @Override
    public String variantMode(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), VARIANT_MODE_STRINGREP);
    }

    @Override
    public boolean isStrictMode(EObject eobj) {
        return JavaScriptVariant.isContainedInStrictFunctionOrScript(eobj);
    }

    @Override
    public boolean isMultiQNScope(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), MULTI_QN_SCOPE);
    }

    @Override
    public boolean allowVersionedTypes(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), VERSIONED_TYPES);
    }

    @Override
    public boolean allowTopLevelStatements(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), TOP_LEVEL_STATEMENTS);
    }

    @Override
    public String getVariantName(EObject eobj) {
        return this.get(this.fileExtensionCalculator.getXpectAwareFileExtension(eobj), VARIANT_NAME);
    }

    @Override
    public String getVariantName(String fileExtension) {
        return this.get(fileExtension, VARIANT_NAME);
    }

    private static class FileExtensionValidationFeaturePair {
        private final String fileExtension;
        private final ValidationFeatureBase validationFeature;

        public FileExtensionValidationFeaturePair(String fileExtension, ValidationFeatureBase validationFeature) {
            this.fileExtension = fileExtension;
            this.validationFeature = validationFeature;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileExtensionValidationFeaturePair) {
                FileExtensionValidationFeaturePair otherKey = (FileExtensionValidationFeaturePair)obj;
                return Objects.equals(this.fileExtension, otherKey.fileExtension) && Objects.equals(this.validationFeature, otherKey.validationFeature);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.fileExtension, this.validationFeature);
        }
    }

    static class ValidationFeature<T>
    extends ValidationFeatureBase {
        private final T defaultValue;

        public ValidationFeature(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public T get(Map<FileExtensionValidationFeaturePair, Object> table, String extension) {
            return (T)table.get(new FileExtensionValidationFeaturePair(extension, this));
        }
    }

    private static class ValidationFeatureBase {
        private ValidationFeatureBase() {
        }
    }
}

