/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external.libraries;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ExternalLibraryFolderUtils {
    public static final String PACKAGE_JSON = "package.json";
    public static final String NPM_ROOT = ".n4npm";

    public static String createTargetPlatformPackageJson() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"name\": \"targetplatform\"");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public static File createTargetPlatformDefinitionFile(File targetPlatformLocationFile) {
        boolean _not;
        File targetPlatformFile = new File(targetPlatformLocationFile, PACKAGE_JSON);
        boolean _exists = targetPlatformFile.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            try {
                Preconditions.checkState((boolean)targetPlatformFile.createNewFile(), (Object)"Error while creating default target platform file.");
                try (OutputStreamWriter fw = null;){
                    FileWriter _fileWriter = new FileWriter(targetPlatformFile);
                    fw = _fileWriter;
                    fw.write(ExternalLibraryFolderUtils.createTargetPlatformPackageJson());
                    fw.flush();
                }
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException e = (IOException)_t;
                    String message = "Error while initializing default target platform file.";
                    throw new RuntimeException("Error while initializing default target platform file.", e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return targetPlatformFile;
    }
}

