/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.codegen;

import java.util.List;
import org.eclipse.n4js.tests.codegen.Classifier;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * Generates the code for an interface.
 */
@SuppressWarnings("all")
public class Interface extends Classifier<Interface> {
  private List<String> extendedInterfaces;
  
  /**
   * Creates a new instance with the given parameters.
   * 
   * @param name the name of the interface
   */
  public Interface(final String name) {
    super(name);
  }
  
  /**
   * Adds a super interface to this interface
   * 
   * @param implementedInterface the interface to add
   * 
   * @return this builder
   */
  public Interface addSuperInterface(final Interface implementedInterface) {
    return this.addSuperInterface(implementedInterface.getName());
  }
  
  /**
   * Adds a super interface to this interface
   * 
   * @param implementedInterface the name of the interface to add
   */
  public Interface addSuperInterface(final String implementedInterface) {
    if ((this.extendedInterfaces == null)) {
      this.extendedInterfaces = CollectionLiterals.<String>newLinkedList();
    }
    this.extendedInterfaces.add(implementedInterface);
    return this;
  }
  
  @Override
  protected CharSequence generateType() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("interface ");
    return _builder;
  }
  
  @Override
  protected CharSequence generateTypeRelations() {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((this.extendedInterfaces != null)) {
        {
          boolean _hasElements = false;
          for(final String i : this.extendedInterfaces) {
            if (!_hasElements) {
              _hasElements = true;
              _builder.append(" extends ");
            } else {
              _builder.appendImmediate(", ", "");
            }
            _builder.append(i);
          }
        }
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
