/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.n4js.compare.ProjectCompareHelper;
import org.eclipse.n4js.compare.ProjectCompareResult;
import org.eclipse.n4js.compare.ProjectComparison;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.projectDescription.ProjectDescriptionFactory;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

public class ApiImplCompareTestHelper {
    @Inject
    private ProjectCompareHelper projectCompareHelper;

    public void assertCorrectChildEntries(ProjectComparison comparison, String fqnOfModule, String nameOfType, Pair<Pair<String, ProjectCompareResult.Status>, String> ... expectedChildrenNameStatusDescription) {
        String fqnOfType = String.valueOf(fqnOfModule) + "/" + nameOfType;
        ProjectComparisonEntry entryForType = this.findEntryForType(comparison, fqnOfType);
        Assert.assertNotNull((String)("cannot find entry for type " + fqnOfType), (Object)entryForType);
        ProjectComparisonEntry[] childEntriesOfType = entryForType.getChildren();
        int expectedChildCount = ((List)Conversions.doWrapArray(expectedChildrenNameStatusDescription)).size();
        Functions.Function1 _function = it -> (String)((Pair)it.getKey()).getKey();
        List expectedChildNames = IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray(expectedChildrenNameStatusDescription)), (Functions.Function1)_function));
        Assert.assertEquals((Object)nameOfType, (Object)this.getElementNameForEntry(entryForType));
        Assert.assertEquals((String)("expected exactly " + Integer.valueOf(expectedChildCount) + " child entries for " + nameOfType), (long)expectedChildCount, (long)((List)Conversions.doWrapArray((Object)childEntriesOfType)).size());
        Functions.Function1 _function_1 = it -> this.getElementNameForEntry((ProjectComparisonEntry)it);
        Assert.assertEquals((String)("child entries of " + nameOfType + " have wrong name(s) or incorrect order"), (Object)expectedChildNames, (Object)IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)childEntriesOfType)), (Functions.Function1)_function_1)));
        int idx = 0;
        while (idx < ((List)Conversions.doWrapArray((Object)childEntriesOfType)).size()) {
            ProjectComparisonEntry currChildEntry = childEntriesOfType[idx];
            ProjectCompareResult.Status expectedStatus = (ProjectCompareResult.Status)((Pair)expectedChildrenNameStatusDescription[idx].getKey()).getValue();
            String expectedDescription = (String)expectedChildrenNameStatusDescription[idx].getValue();
            this.assertDiff(currChildEntry, expectedStatus, expectedDescription);
            ++idx;
        }
    }

    public void assertCorrectTypeEntry(ProjectComparison comparision, String fqnOfModule, Pair<Pair<String, ProjectCompareResult.Status>, String> ... expectedTypeStatusDescriptions) {
        int idx = 0;
        while (idx < ((List)Conversions.doWrapArray(expectedTypeStatusDescriptions)).size()) {
            String elementName = (String)((Pair)expectedTypeStatusDescriptions[idx].getKey()).getKey();
            ProjectCompareResult.Status elementStatus = (ProjectCompareResult.Status)((Pair)expectedTypeStatusDescriptions[idx].getKey()).getValue();
            String elementDescription = (String)expectedTypeStatusDescriptions[idx].getValue();
            String fqnOfType = String.valueOf(fqnOfModule) + "/" + elementName;
            ProjectComparisonEntry entryForType = this.findEntryForType(comparision, fqnOfType);
            this.assertDiff(entryForType, elementStatus, elementDescription);
            ++idx;
        }
    }

    private void assertDiff(ProjectComparisonEntry entry, ProjectCompareResult.Status status, String description) {
        Assert.assertNotNull((Object)entry);
        Assert.assertSame((String)"wrong status", (Object)status, (Object)this.getStatusForFirstImplementation(entry));
        Assert.assertEquals((String)"wrong description", (Object)description, (Object)this.getDescriptionForFirstImplementation(entry));
    }

    public ProjectComparisonEntry findEntryForType(ProjectComparison comparison, String fqn) {
        Predicate<ProjectComparisonEntry> _function = entry -> {
            String _elementFqnForEntry = this.getElementFqnForEntry((ProjectComparisonEntry)entry);
            return Objects.equal((Object)_elementFqnForEntry, (Object)fqn);
        };
        return comparison.getAllEntries().filter(_function).findFirst().orElse(null);
    }

    public String getElementNameForEntry(ProjectComparisonEntry entry) {
        Functions.Function1 _function = it -> it.getName();
        return (String)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)entry.getAllElements())), IdentifiableElement.class), (Functions.Function1)_function));
    }

    public String getElementFqnForEntry(ProjectComparisonEntry entry) {
        Functions.Function1 _function = it -> {
            TModule _containingModule = it.getContainingModule();
            String _qualifiedName = null;
            if (_containingModule != null) {
                _qualifiedName = _containingModule.getQualifiedName();
            }
            String _plus = String.valueOf(_qualifiedName) + "/";
            String _name = it.getName();
            return String.valueOf(_plus) + _name;
        };
        return (String)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)entry.getAllElements())), Type.class), (Functions.Function1)_function));
    }

    private ProjectCompareResult.Status getStatusForFirstImplementation(ProjectComparisonEntry entry) {
        return this.projectCompareHelper.compareApiImpl((ProjectComparisonEntry)entry, (int)0).status;
    }

    private String getDescriptionForFirstImplementation(ProjectComparisonEntry entry) {
        return this.projectCompareHelper.compareApiImpl((ProjectComparisonEntry)entry, (int)0).description;
    }

    public ProjectReference createProjectReference(String projectNameOfTargetProject) {
        ProjectReference pref = ProjectDescriptionFactory.eINSTANCE.createProjectReference();
        pref.setProjectName(projectNameOfTargetProject);
        return pref;
    }
}

