/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.n4js.JSLibSingleTestConfig;
import org.eclipse.n4js.JSLibSingleTestConfigProvider;

public class TestCodeProvider {
    static Logger logger = Logger.getLogger((String)"debugLibraryParsing");

    public static Collection<JSLibSingleTestConfig> getDataFromZippedRoot(String rootName, JSLibSingleTestConfigProvider configProvider) throws IOException, URISyntaxException {
        URL rootURL = Thread.currentThread().getContextClassLoader().getResource(rootName);
        ArrayList<JSLibSingleTestConfig> entries = new ArrayList<JSLibSingleTestConfig>();
        try (ZipFile root = new ZipFile(new File(rootURL.toURI()));){
            TestCodeProvider.filterDataFilesFromZippedFolder(root, rootName, entries, configProvider);
        }
        return entries;
    }

    public static Collection<JSLibSingleTestConfig> getDataFromZippedRoots(Collection<String> rootNames, JSLibSingleTestConfigProvider configProvider) throws IOException, URISyntaxException {
        ArrayList<JSLibSingleTestConfig> mergeEntries = new ArrayList<JSLibSingleTestConfig>();
        for (String rootName : rootNames) {
            mergeEntries.addAll(TestCodeProvider.getDataFromZippedRoot(rootName, configProvider));
        }
        return mergeEntries;
    }

    public static String getContentsFromFileEntry(final ZipEntry entry, String rootName) throws IOException, URISyntaxException {
        URL rootURL = Thread.currentThread().getContextClassLoader().getResource(rootName);
        Throwable throwable = null;
        Object var4_5 = null;
        try (final ZipFile root = new ZipFile(new File(rootURL.toURI()));){
            ByteSource byteSource = new ByteSource(){

                public InputStream openStream() throws IOException {
                    return root.getInputStream(entry);
                }
            };
            CharSource charSrc = byteSource.asCharSource(Charsets.UTF_8);
            return charSrc.read();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void filterDataFilesFromZippedFolder(ZipFile file, final String resourceName, Collection<JSLibSingleTestConfig> files, final JSLibSingleTestConfigProvider configProvider) {
        Enumeration<? extends ZipEntry> entries = file.entries();
        UnmodifiableIterator fileEntries = Iterators.filter((Iterator)Iterators.forEnumeration(entries), (Predicate)new Predicate<ZipEntry>(){

            public boolean apply(ZipEntry input) {
                return !input.isDirectory();
            }
        });
        ArrayList entriesAsList = Lists.newArrayList((Iterator)fileEntries);
        files.addAll(Lists.transform((List)entriesAsList, (Function)new Function<ZipEntry, JSLibSingleTestConfig>(){

            public JSLibSingleTestConfig apply(ZipEntry input) {
                return configProvider.createConfig(input, resourceName);
            }
        }));
    }
}

