/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.inject.Injector;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.testing.IInjectorProvider;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.testing.internal.InjectorProviders;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public final class XtextParametrizedRunner
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final ArrayList<Runner> runners = new ArrayList();

    public XtextParametrizedRunner(Class<?> klass) throws Throwable {
        super(klass, NO_RUNNERS);
        FrameworkMethod parametersMethod = this.getParametersMethod();
        if (parametersMethod != null) {
            Parameters parameters = (Parameters)parametersMethod.getAnnotation(Parameters.class);
            this.createRunnersForParameters(this.allParameters(), parameters.name());
        } else {
            FrameworkMethod parametersProviderMethod = this.getParametersProviderMethod();
            ParametersProvider parameters = (ParametersProvider)parametersProviderMethod.getAnnotation(ParametersProvider.class);
            this.createRunnersForParameters(this.allParameters(), parameters.name());
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private Iterable<Object> allParameters() throws Throwable {
        FrameworkMethod parametersMethod = this.getParametersMethod();
        if (parametersMethod != null) {
            Object parameters = parametersMethod.invokeExplosively(null, new Object[0]);
            if (parameters instanceof Iterable) {
                return (Iterable)parameters;
            }
            throw this.parametersMethodReturnedWrongType(parametersMethod);
        }
        FrameworkMethod parametersProviderMethod = this.getParametersProviderMethod();
        if (parametersProviderMethod != null) {
            Object provider = parametersProviderMethod.invokeExplosively(null, new Object[0]);
            if (provider instanceof Provider) {
                Object parameters;
                Injector injector;
                IInjectorProvider injectorProvider = InjectorProviders.getOrCreateInjectorProvider((TestClass)this.getTestClass());
                if (injectorProvider != null && (injector = injectorProvider.getInjector()) != null) {
                    injector.injectMembers(provider);
                }
                if ((parameters = ((Provider)provider).get()) instanceof Iterable) {
                    return (Iterable)parameters;
                }
            }
            throw this.parametersProviderMethodReturnedWrongType(parametersProviderMethod);
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        return this.getAnnotatedPublicStaticMethod(Parameters.class);
    }

    private FrameworkMethod getParametersProviderMethod() throws Exception {
        return this.getAnnotatedPublicStaticMethod(ParametersProvider.class);
    }

    private FrameworkMethod getAnnotatedPublicStaticMethod(Class<? extends Annotation> anno) {
        List methods = this.getTestClass().getAnnotatedMethods(anno);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        return null;
    }

    private void createRunnersForParameters(Iterable<Object> allParameters, String namePattern) throws InitializationError, Exception {
        try {
            int i = 0;
            for (Object parametersOfSingleTest : allParameters) {
                if (parametersOfSingleTest instanceof Object[]) {
                    Object[] parameters = (Object[])parametersOfSingleTest;
                    String name = this.nameFor(namePattern, i, parameters);
                    ParametrizedXtextTestClassRunner runner = new ParametrizedXtextTestClassRunner(this.getTestClass().getJavaClass(), parameters, name);
                    this.runners.add((Runner)runner);
                } else {
                    String name = parametersOfSingleTest.toString();
                    ParametrizedXtextTestClassRunner runner = new ParametrizedXtextTestClassRunner(this.getTestClass().getJavaClass(), new Object[]{parametersOfSingleTest}, name);
                    this.runners.add((Runner)runner);
                }
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw this.unexpectedArrayElement();
        }
    }

    private String nameFor(String namePattern, int index, Object[] parameters) {
        String finalPattern = namePattern.replaceAll("\\{index\\}", Integer.toString(index));
        String name = MessageFormat.format(finalPattern, parameters);
        return "[" + name + "]";
    }

    private Exception parametersMethodReturnedWrongType(FrameworkMethod parametersMethod) throws Exception {
        String className = this.getTestClass().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, parametersMethod.getName());
        return new Exception(message);
    }

    private Exception parametersProviderMethodReturnedWrongType(FrameworkMethod parametersMethod) throws Exception {
        String className = this.getTestClass().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Provider for an Iterable of arrays.", className, parametersMethod.getName());
        return new Exception(message);
    }

    private Exception unexpectedArrayElement() throws Exception {
        FrameworkMethod method = this.getParametersMethod();
        if (method != null) {
            return this.parametersMethodReturnedWrongType(method);
        }
        return this.parametersProviderMethodReturnedWrongType(this.getParametersProviderMethod());
    }

    List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameter.class);
    }

    boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public int value() default 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
        public String name() default "{index}";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ParametersProvider {
        public String name() default "{index}";
    }

    private final class ParametrizedXtextTestClassRunner
    extends XtextRunner {
        private final Object[] fParameters;
        private final String fName;

        ParametrizedXtextTestClassRunner(Class<?> type, Object[] parameters, String name) throws InitializationError {
            super(type);
            this.fParameters = parameters;
            this.fName = name;
        }

        public Object createTest() throws Exception {
            Injector injector;
            Object object = XtextParametrizedRunner.this.fieldsAreAnnotated() ? this.createTestUsingFieldInjection() : this.createTestUsingConstructorInjection();
            IInjectorProvider injectorProvider = this.getOrCreateInjectorProvider();
            if (injectorProvider != null && (injector = injectorProvider.getInjector()) != null) {
                injector.injectMembers(object);
            }
            return object;
        }

        private Object createTestUsingConstructorInjection() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.fParameters);
        }

        private Object createTestUsingFieldInjection() throws Exception {
            List<FrameworkField> annotatedFieldsByParameter = XtextParametrizedRunner.this.getAnnotatedFieldsByParameter();
            if (annotatedFieldsByParameter.size() != this.fParameters.length) {
                throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + this.fParameters.length + ".");
            }
            Object testClassInstance = this.getTestClass().getJavaClass().newInstance();
            for (FrameworkField each : annotatedFieldsByParameter) {
                Field field = each.getField();
                Parameter annotation = field.getAnnotation(Parameter.class);
                int index = annotation.value();
                try {
                    field.set(testClassInstance, this.fParameters[index]);
                }
                catch (IllegalArgumentException iare) {
                    throw new Exception(String.valueOf(this.getTestClass().getName()) + ": Trying to set " + field.getName() + " with the value " + this.fParameters[index] + " that is not the right type (" + this.fParameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
                }
            }
            return testClassInstance;
        }

        protected String getName() {
            return this.fName;
        }

        protected String testName(FrameworkMethod method) {
            return String.valueOf(method.getName()) + this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
            if (XtextParametrizedRunner.this.fieldsAreAnnotated()) {
                this.validateZeroArgConstructor(errors);
            }
        }

        protected void validateFields(List<Throwable> errors) {
            super.validateFields(errors);
            if (XtextParametrizedRunner.this.fieldsAreAnnotated()) {
                List<FrameworkField> annotatedFieldsByParameter = XtextParametrizedRunner.this.getAnnotatedFieldsByParameter();
                int[] usedIndices = new int[annotatedFieldsByParameter.size()];
                for (FrameworkField each : annotatedFieldsByParameter) {
                    int index = each.getField().getAnnotation(Parameter.class).value();
                    if (index < 0 || index > annotatedFieldsByParameter.size() - 1) {
                        errors.add(new Exception("Invalid @Parameter value: " + index + ". @Parameter fields counted: " + annotatedFieldsByParameter.size() + ". Please use an index between 0 and " + (annotatedFieldsByParameter.size() - 1) + "."));
                        continue;
                    }
                    int n = index;
                    usedIndices[n] = usedIndices[n] + 1;
                }
                int index = 0;
                while (index < usedIndices.length) {
                    int numberOfUse = usedIndices[index];
                    if (numberOfUse == 0) {
                        errors.add(new Exception("@Parameter(" + index + ") is never used."));
                    } else if (numberOfUse > 1) {
                        errors.add(new Exception("@Parameter(" + index + ") is used more than once (" + numberOfUse + ")."));
                    }
                    ++index;
                }
            }
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }
    }
}

