/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.tests.helper;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4idl.migrations.MigrationSwitchComputer;
import org.eclipse.n4js.n4idl.migrations.OrSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.n4js.n4idl.migrations.TypeSwitchCondition;
import org.eclipse.n4js.n4idl.tests.helper.N4IDLTypeRefTestHelper;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;

public class AbstractN4IDLTypeSwitchTest
extends Assert {
    @Inject
    protected MigrationSwitchComputer switchComputer;
    @Inject
    protected N4JSTypeSystem typeSystem;
    @Inject
    @Extension
    protected N4IDLTypeRefTestHelper _n4IDLTypeRefTestHelper;

    public String computeAndConvertToTypeRef(String typeExpression, String preamble) {
        try {
            TypeRef typeRef = this._n4IDLTypeRefTestHelper.makeTypeRef(typeExpression, preamble);
            RuleEnvironment env = this.typeSystem.createRuleEnvironmentForContext(typeRef, typeRef.eResource());
            TypeRef result = this.switchComputer.toSwitchRecognizableTypeRef(env, typeRef);
            return result.getTypeRefAsString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public SwitchCondition computeSwitch(String typeExpression, String preamble) {
        try {
            return this.switchComputer.compute(this._n4IDLTypeRefTestHelper.makeTypeRef(typeExpression, preamble));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Resource findContextResource(SwitchCondition condition) {
        TypeSwitchCondition _head = (TypeSwitchCondition)IterableExtensions.head((Iterable)Iterables.filter((Iterable)condition, TypeSwitchCondition.class));
        Type _type = null;
        if (_head != null) {
            _type = _head.type;
        }
        Resource _eResource = null;
        if (_type != null) {
            _eResource = _type.eResource();
        }
        return _eResource;
    }

    protected RuleEnvironment createRuleEnvironment(SwitchCondition condition) {
        return RuleEnvironmentExtensions.newRuleEnvironment((Resource)this.findContextResource(condition));
    }

    public TypeRef toTypeRef(SwitchCondition condition) {
        RuleEnvironment ruleEnv = RuleEnvironmentExtensions.newRuleEnvironment((Resource)this.findContextResource(condition));
        return this.switchComputer.toTypeRef(ruleEnv, condition);
    }

    public String compute(String typeExpression, String preamble) {
        return this.computeSwitch(typeExpression, preamble).toString();
    }

    public void assertSwitchDoesNotContainOr(SwitchCondition condition) {
        this.assertSwitchDoesNotContainOr(condition, condition);
    }

    private void assertSwitchDoesNotContainOr(SwitchCondition rootCondition, SwitchCondition condition) {
        if (condition instanceof OrSwitchCondition) {
            Assert.fail((String)("Switch condition did contain OR condition: " + rootCondition));
        }
        Consumer<SwitchCondition> _function = c -> this.assertSwitchDoesNotContainOr(rootCondition, (SwitchCondition)c);
        condition.subConditions().forEach(_function);
    }
}

