/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.tests.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4idl.tests.helper.N4IDLParseHelper;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

public class N4IDLTypeRefTestHelper {
    @Inject
    @Extension
    private N4IDLParseHelper _n4IDLParseHelper;
    @Inject
    @Extension
    private ValidationTestHelper _validationTestHelper;
    @Inject
    private N4JSTypeSystem typeSystem;

    public TypeRef makeTypeRef(String typeExpression, String preamble) {
        return this.makeTypeRefs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{typeExpression})), preamble).get(0);
    }

    public List<TypeRef> makeTypeRefs(List<String> typeExpressions, String preamble) {
        List<Pair<String, String>> expressionVariables = this.distinctNames(typeExpressions, "typeExpression");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(preamble);
        _builder.newLineIfNotEmpty();
        _builder.append("@VersionAware");
        _builder.newLine();
        _builder.append("function f() {");
        _builder.newLine();
        for (Pair<String, String> e : expressionVariables) {
            _builder.append("\t");
            _builder.append("let ");
            String _key = (String)e.getKey();
            _builder.append(_key, "\t");
            _builder.append(" : ");
            String _value = (String)e.getValue();
            _builder.append(_value, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        String module = _builder.toString();
        Functions.Function1 _function = it -> (String)it.getKey();
        Functions.Function1 _function_1 = decl -> decl.getDeclaredTypeRef();
        return IterableExtensions.toList((Iterable)ListExtensions.map(this.parseAndFindVariableDeclarations(module, IterableExtensions.toList((Iterable)ListExtensions.map(expressionVariables, (Functions.Function1)_function))), (Functions.Function1)_function_1));
    }

    private List<VariableDeclaration> parseAndFindVariableDeclarations(String module, List<String> variableDeclarations) {
        try {
            boolean _notEquals;
            Script script = this._n4IDLParseHelper.parseN4IDL(module);
            this._validationTestHelper.assertNoIssues((EObject)script);
            Functions.Function1 _function = decl -> decl.getName();
            Functions.Function1 _function_1 = decl -> decl;
            Map variableDeclarationsByName = IterableExtensions.toMap((Iterable)IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)script.eAllContents(), VariableDeclaration.class)), (Functions.Function1)_function, (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = name -> (VariableDeclaration)variableDeclarationsByName.get(name);
            List resultingVariableDeclaration = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(variableDeclarations, (Functions.Function1)_function_2)));
            int _size = resultingVariableDeclaration.size();
            int _size_1 = variableDeclarations.size();
            boolean bl = _notEquals = _size != _size_1;
            if (_notEquals) {
                Assert.fail((String)("Failed to find all specified variable declarations " + variableDeclarations + " in N4IDL module:\n " + module));
            }
            return resultingVariableDeclaration;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public <T> List<Pair<String, T>> distinctNames(List<T> elements, String baseName) {
        IntFunction<Pair> _function = index -> {
            Object _get = elements.get(index);
            return Pair.of((Object)(String.valueOf(baseName) + Integer.valueOf(index)), _get);
        };
        return IntStream.range(0, elements.size()).mapToObj(_function).collect(Collectors.toList());
    }

    public TypeRef makeTypeRef(String typeExpression, List<String> existingClasses) {
        return this.makeTypeRef(typeExpression, this.classes((String[])Conversions.unwrapArray(existingClasses, String.class)));
    }

    public List<TypeRef> makeTypeRefs(List<String> valueExpressions, List<String> typeExpressions, String preamble) {
        List<Pair<String, String>> valueVariables = this.distinctNames(valueExpressions, "value");
        List<Pair<String, String>> typeExpressionVariables = this.distinctNames(typeExpressions, "type");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(preamble);
        _builder.newLineIfNotEmpty();
        _builder.append("@VersionAware");
        _builder.newLine();
        _builder.append("function f() {");
        _builder.newLine();
        for (Pair<String, String> v : valueVariables) {
            _builder.append("\t");
            _builder.append("let ");
            String _key = (String)v.getKey();
            _builder.append(_key, "\t");
            _builder.append(" = ");
            String _value = (String)v.getValue();
            _builder.append(_value, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        for (Pair<String, String> t : typeExpressionVariables) {
            _builder.append("\t");
            _builder.append("let ");
            String _key_1 = (String)t.getKey();
            _builder.append(_key_1, "\t");
            _builder.append(" : ");
            String _value_1 = (String)t.getValue();
            _builder.append(_value_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        String module = _builder.toString();
        Functions.Function1 _function = v_1 -> (String)v_1.getKey();
        List _map = ListExtensions.map(valueVariables, (Functions.Function1)_function);
        Functions.Function1 _function_1 = t_1 -> (String)t_1.getKey();
        List _map_1 = ListExtensions.map(typeExpressionVariables, (Functions.Function1)_function_1);
        Iterable allVariableNames = Iterables.concat((Iterable)_map, (Iterable)_map_1);
        List<VariableDeclaration> declarations = this.parseAndFindVariableDeclarations(module, IterableExtensions.toList((Iterable)allVariableNames));
        Functions.Function1 _function_2 = decl -> {
            boolean _tripleNotEquals;
            TypeRef _declaredTypeRef = decl.getDeclaredTypeRef();
            boolean bl = _tripleNotEquals = _declaredTypeRef != null;
            if (_tripleNotEquals) {
                return decl.getDeclaredTypeRef();
            }
            return this.typeSystem.tau((TypableElement)decl);
        };
        return ListExtensions.map(declarations, (Functions.Function1)_function_2);
    }

    public String classes(String ... classNames) {
        StringConcatenation _builder = new StringConcatenation();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            _builder.newLineIfNotEmpty();
            _builder.append("class ");
            _builder.append(e);
            _builder.append(" {}");
            _builder.newLineIfNotEmpty();
            ++n2;
        }
        return _builder.toString();
    }
}

