/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.issues;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.n4js.tests.issues.IssuePropertyMatcherBase;
import org.eclipse.xtext.validation.Issue;

public class IssuePropertyEqualsMatcher<T>
extends IssuePropertyMatcherBase {
    private final T expectedValue;
    private final Function<Issue, T> getActualValue;

    public IssuePropertyEqualsMatcher(String propertyName, T expectedValue, Function<Issue, T> getActualValue) {
        super(propertyName);
        this.expectedValue = Objects.requireNonNull(expectedValue);
        this.getActualValue = Objects.requireNonNull(getActualValue);
    }

    @Override
    public boolean matches(Issue issue) {
        return this.expectedValue.equals(this.getActualValue.apply(issue));
    }

    @Override
    protected String explainMismatch(Issue issue) {
        return "Value '" + this.getActualValue.apply(issue) + "' is not equal to expected value'" + this.expectedValue + "'";
    }

    @Override
    public String getDescription() {
        return "Property '" + this.getPropertyName() + "' equals '" + this.expectedValue + "'";
    }
}

