/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.issues;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.tests.issues.IssueMatcher;
import org.eclipse.n4js.tests.issues.IssuePropertyMatcherBuilder;
import org.eclipse.n4js.tests.issues.URIPropertyMatcher;
import org.eclipse.xtext.validation.Issue;

public class URIPropertyMatcherBuilder
extends IssuePropertyMatcherBuilder {
    private final Function<Issue, URI> getActualValue;

    public URIPropertyMatcherBuilder(IssueMatcher issueMatcher, String propertyName, Function<Issue, URI> getActualValue) {
        super(issueMatcher, propertyName);
        this.getActualValue = Objects.requireNonNull(getActualValue);
    }

    public IssueMatcher startsWith(URI expectedPrefix) {
        return this.addPropertyMatcher(URIPropertyMatcher.Mode.StartsWith, expectedPrefix);
    }

    public IssueMatcher endsWith(URI expectedSuffix) {
        return this.addPropertyMatcher(URIPropertyMatcher.Mode.EndsWith, expectedSuffix);
    }

    public IssueMatcher equals(URI expectedValue) {
        return this.addPropertyMatcher(URIPropertyMatcher.Mode.Equals, expectedValue);
    }

    private IssueMatcher addPropertyMatcher(URIPropertyMatcher.Mode mode, URI expectedPattern) {
        return this.addPropertyMatcher(new URIPropertyMatcher(this.getPropertyName(), mode, expectedPattern, this.getActualValue));
    }
}

