/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.projectModel;

import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.tests.projectModel.AbstractProjectModelTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractN4JSCoreTest
extends AbstractProjectModelTest {
    protected abstract IN4JSCore getN4JSCore();

    @Test
    public void testCreateProjectAndCheckExists_01() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.trimSegments(1).appendSegment("doesNotExist"));
        Assert.assertNotNull((Object)project);
        Assert.assertFalse((boolean)project.exists());
    }

    @Test
    public void testCreateProjectAndCheckExists_02() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI);
        Assert.assertNotNull((Object)project);
        Assert.assertTrue((boolean)project.exists());
    }

    @Test
    public void testCreateYieldsDifferentInstances() {
        IN4JSProject first = this.getN4JSCore().create(this.myProjectURI);
        IN4JSProject second = this.getN4JSCore().create(this.myProjectURI);
        Assert.assertNotSame((Object)first, (Object)second);
    }

    @Test
    public void testCreateYieldsEqualsInstances_01() {
        IN4JSProject first = this.getN4JSCore().create(this.myProjectURI);
        IN4JSProject second = this.getN4JSCore().create(this.myProjectURI);
        Assert.assertEquals((Object)first, (Object)second);
    }

    @Test
    public void testCreateYieldsEqualsInstances_02() {
        URI doesNotExist = this.myProjectURI.trimSegments(1).appendSegment("doesNotExist");
        IN4JSProject first = this.getN4JSCore().create(doesNotExist);
        IN4JSProject second = this.getN4JSCore().create(doesNotExist);
        Assert.assertEquals((Object)first, (Object)second);
    }

    @Test
    public void testProjectId_01() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.trimSegments(1).appendSegment("doesNotExist"));
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)"doesNotExist", (Object)project.getProjectName());
    }

    @Test
    public void testProjectId_02() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI);
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)"myProject", (Object)project.getProjectName());
    }

    @Test
    public void testGetDepthOfLocation() {
        String[] emptySegments = new String[]{"", "", ""};
        URI uri0 = this.myProjectURI;
        URI uri1 = this.myProjectURI.appendSegment("someFile.txt");
        URI uri2 = this.myProjectURI.appendSegment("someFolder").appendSegment("someFile.txt");
        URI uriBad = this.myProjectURI.trimSegments(1).appendSegment("DoesNotExist").appendSegment("someFile.txt");
        Assert.assertEquals((long)0L, (long)this.getN4JSCore().getDepthOfLocation(uri0));
        Assert.assertEquals((long)0L, (long)this.getN4JSCore().getDepthOfLocation(uri0.appendSegments(emptySegments)));
        Assert.assertEquals((long)1L, (long)this.getN4JSCore().getDepthOfLocation(uri1));
        Assert.assertEquals((long)1L, (long)this.getN4JSCore().getDepthOfLocation(uri1.appendSegments(emptySegments)));
        Assert.assertEquals((long)2L, (long)this.getN4JSCore().getDepthOfLocation(uri2));
        Assert.assertEquals((long)2L, (long)this.getN4JSCore().getDepthOfLocation(uri2.appendSegments(emptySegments)));
        Assert.assertEquals((long)-1L, (long)this.getN4JSCore().getDepthOfLocation(uriBad));
        Assert.assertEquals((long)-1L, (long)this.getN4JSCore().getDepthOfLocation(uriBad.appendSegments(emptySegments)));
    }
}

