/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.projects;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.URIUtils;

@Singleton
public class AutoDiscoveryFileBasedWorkspace
extends FileBasedWorkspace {
    @Inject
    public AutoDiscoveryFileBasedWorkspace(ProjectDescriptionLoader projectDescriptionLoader) {
        super(projectDescriptionLoader);
    }

    public URI findProjectWith(URI nestedLocation) {
        URI closestProjectLocation = AutoDiscoveryFileBasedWorkspace.findClosestProjectLocation(nestedLocation);
        URI knownProjectLocation = super.findProjectWith(nestedLocation);
        if (!(closestProjectLocation == null || knownProjectLocation != null && knownProjectLocation.equals(closestProjectLocation))) {
            this.registerProject(closestProjectLocation);
        }
        return closestProjectLocation;
    }

    private static URI findClosestProjectLocation(URI location) {
        URI nestedLocation = URIUtils.normalize((URI)location);
        int segmentCount = 0;
        if (nestedLocation.isFile()) {
            File directory = new File(nestedLocation.toFileString());
            while (directory != null) {
                if (AutoDiscoveryFileBasedWorkspace.isProjectDirectory(directory)) {
                    URI projectLocation = URI.createFileURI((String)directory.getAbsolutePath());
                    return projectLocation;
                }
                nestedLocation = nestedLocation.trimSegments(segmentCount++);
                directory = directory.getParentFile();
            }
        }
        return null;
    }

    private static boolean isProjectDirectory(File directory) {
        return directory.toPath().isAbsolute() && N4JSProject.isN4JSProjectDirectory((URI)URI.createFileURI((String)directory.getPath()));
    }
}

