/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.n4js.ui.N4JSHierarchicalNameComputerHelper;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;

/**
 * This is the default provider for labels shown for hyperlink hovers.
 * As labels shown in outline and content assist can look differently (as different use case),
 * this is separated here.
 * <br/><br/>
 * Every time {@code link org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkLabelProvider private ILabelProvider labelProvider} is used
 * this label provider is injected.
 */
@SuppressWarnings("all")
public class N4JSHyperlinkLabelProvider extends N4JSLabelProvider {
  @Inject
  private N4JSLabelProvider labelProviderDelegate;
  
  @Inject
  public N4JSHyperlinkLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }
  
  /**
   * Customized text for hyperlinks.
   */
  @Override
  public String getText(final Object element) {
    if ((element instanceof EObject)) {
      final String text = N4JSHierarchicalNameComputerHelper.calculateLogicallyQualifiedDisplayName(((EObject)element), 
        this.labelProviderDelegate, true);
      return text;
    } else {
      return this.labelProviderDelegate.getText(element);
    }
  }
}
