/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.utils;

import org.eclipse.n4js.ui.proposals.imports.N4JSReplacementTextApplier;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;

/**
 * Type-safe access to some user data entries of completion proposals.
 */
@SuppressWarnings("all")
public class ConfigurableCompletionProposalExtensions {
  private final static String KEY_REPLACEMENT_SUFFIX = "REPLACEMENT_SUFFIX";
  
  private final static String KEY_CURSOR_OFFSET = "CURSOR_OFFSET";
  
  private final static String KEY_SECONDARY_MEMBER = "SECONDARY_MEMBER";
  
  /**
   * See {@link #setReplacementSuffix(ConfigurableCompletionProposal, String)}.
   */
  public static String getReplacementSuffix(final ConfigurableCompletionProposal proposal) {
    final Object suffix = proposal.getAdditionalData(ConfigurableCompletionProposalExtensions.KEY_REPLACEMENT_SUFFIX);
    String _xifexpression = null;
    if ((suffix instanceof String)) {
      _xifexpression = ((String)suffix);
    } else {
      _xifexpression = "";
    }
    return _xifexpression;
  }
  
  /**
   * If set, an additional string will be appended by {@link N4JSReplacementTextApplier} after ordinary
   * replacement text when the given proposal is applied. The cursor will be placed after this suffix,
   * unless a {@link #setCursorOffset(ConfigurableCompletionProposal, int) cursor offset} is set to
   * change this default behavior.
   */
  public static void setReplacementSuffix(final ConfigurableCompletionProposal proposal, final String suffix) {
    proposal.setAdditionalData(ConfigurableCompletionProposalExtensions.KEY_REPLACEMENT_SUFFIX, suffix);
  }
  
  /**
   * See {@link #setCursorOffset(ConfigurableCompletionProposal, int)}.
   */
  public static int getCursorOffset(final ConfigurableCompletionProposal proposal) {
    final Object offset = proposal.getAdditionalData(ConfigurableCompletionProposalExtensions.KEY_CURSOR_OFFSET);
    int _xifexpression = (int) 0;
    if ((offset instanceof Integer)) {
      _xifexpression = ((Integer)offset).intValue();
    } else {
      _xifexpression = 0;
    }
    return _xifexpression;
  }
  
  /**
   * If set to a non-zero value, the cursor won't appear at the default location after the given proposal
   * is applied but instead be shifted by the given offset (handled by {@link N4JSReplacementTextApplier}).
   */
  public static void setCursorOffset(final ConfigurableCompletionProposal proposal, final int offset) {
    proposal.setAdditionalData(ConfigurableCompletionProposalExtensions.KEY_CURSOR_OFFSET, Integer.valueOf(offset));
  }
  
  /**
   * See {@link #setSecondaryMember(ConfigurableCompletionProposal, boolean)}.
   */
  public static boolean isSecondaryMember(final ConfigurableCompletionProposal proposal) {
    final Object result = proposal.getAdditionalData(ConfigurableCompletionProposalExtensions.KEY_SECONDARY_MEMBER);
    boolean _xifexpression = false;
    if ((result instanceof Boolean)) {
      _xifexpression = ((Boolean)result).booleanValue();
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }
  
  /**
   * Tells if the given proposal represents a member that is usually of lesser relevance to the user.
   */
  public static void setSecondaryMember(final ConfigurableCompletionProposal proposal, final boolean value) {
    proposal.setAdditionalData(ConfigurableCompletionProposalExtensions.KEY_SECONDARY_MEMBER, Boolean.valueOf(value));
  }
}
